/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cover.stmt;

import java.util.List;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.quilt.cl.ClassTransformer;
import org.quilt.cl.ClassXformer;
import org.quilt.cover.stmt.Ephemera;
import org.quilt.cover.stmt.StmtRegistry;

public class ClassAction
implements ClassXformer {
    private static String name_ = null;
    private ClassTransformer classTrans;
    private ClassGen clazz_;
    private String className;
    private String prefixedClassName;
    private ConstantPoolGen cpGen_;
    private InstructionFactory factory;
    boolean clinitExists = false;
    int clinitIndex = -1;
    private static StmtRegistry stmtReg = null;
    private Ephemera eph;

    public ClassAction() {
    }

    public ClassAction(StmtRegistry reg) {
        stmtReg = reg;
        this.setName(this.getClass().getName());
    }

    public void setClassTransformer(ClassTransformer ct) {
        this.classTrans = ct;
    }

    public void preMethods(ClassGen clazz) {
        this.clazz_ = clazz;
        this.cpGen_ = clazz.getConstantPool();
        this.className = this.clazz_.getClassName();
        this.prefixedClassName = "class$QIC";
        this.eph = new Ephemera(this.className);
        if (!stmtReg.putEphemera(this.className, this.eph)) {
            System.out.println("ClassAction.preMethods INTERNAL ERRROR -  couldn't register ephemeral data");
        }
        if (clazz.containsField("q$$q") != null) {
            System.out.println("ClassAction.preMethods WARNING - " + this.className + " already has q$$q field, aborting");
            this.classTrans.abort();
        } else {
            FieldGen field = new FieldGen(9, (Type)new ArrayType((Type)Type.INT, 1), "q$$q", this.cpGen_);
            clazz.addField(field.getField());
            field = new FieldGen(9, (Type)Type.INT, "q$$qID", this.cpGen_);
            clazz.addField(field.getField());
            field = new FieldGen(25, (Type)new ObjectType("org.quilt.cover.stmt.StmtRegistry"), "q$$qStmtReg", this.cpGen_);
            clazz.addField(field.getField());
            field = new FieldGen(9, (Type)Type.INT, "q$$qVer", this.cpGen_);
            clazz.addField(field.getField());
            field = new FieldGen(9, (Type)new ObjectType("java.lang.Class"), "class$QIC", this.cpGen_);
            clazz.addField(field.getField());
            Method[] m = clazz.getMethods();
            int i = 0;
            while (i < m.length) {
                if (m[i].getName().equals("<clinit>")) {
                    this.clinitExists = true;
                    this.clinitIndex = i;
                    break;
                }
                ++i;
            }
        }
    }

    private void dumpIList(InstructionList ilist, String where) {
        if (ilist != null) {
            System.out.println(where + ": instruction list");
            int i = 0;
            InstructionHandle ih = ilist.getStart();
            while (ih != null) {
                System.out.println("  " + i++ + "  " + ih);
                ih = ih.getNext();
            }
        }
    }

    private void addClass$Method() {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(8, (Type)new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, new String[]{"arg0"}, "class$", this.className, il, this.cpGen_);
        InstructionHandle ih_0 = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        InstructionHandle ih_1 = il.append((Instruction)this.factory.createInvoke("java.lang.Class", "forName", (Type)new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, (short)184));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.OBJECT));
        InstructionHandle ih_5 = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)1));
        InstructionHandle ih_6 = il.append((Instruction)this.factory.createNew("java.lang.NoClassDefFoundError"));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)1));
        il.append((Instruction)this.factory.createInvoke("java.lang.ClassNotFoundException", "getMessage", (Type)Type.STRING, Type.NO_ARGS, (short)182));
        il.append((Instruction)this.factory.createInvoke("java.lang.NoClassDefFoundError", "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        InstructionHandle ih_17 = il.append(InstructionConstants.ATHROW);
        method.addExceptionHandler(ih_0, ih_1, ih_5, new ObjectType("java.lang.ClassNotFoundException"));
        method.setMaxStack();
        method.setMaxLocals();
        this.clazz_.addMethod(method.getMethod());
        il.dispose();
    }

    public void postMethods(ClassGen clazz) {
        InstructionList ilist;
        MethodGen mg;
        int counterCount = this.eph.getCounterCount();
        List methodNames = this.eph.getMethodNames();
        List methodEnds = this.eph.getMethodEnds();
        if (clazz != this.clazz_) {
            System.out.println("ClassAction.postMethods: INTERNAL ERROR: preMethods class different from postMethods");
        }
        this.factory = new InstructionFactory(this.clazz_, this.cpGen_);
        this.addClass$Method();
        if (this.clinitExists) {
            mg = new MethodGen(this.clazz_.getMethodAt(this.clinitIndex), this.className, this.clazz_.getConstantPool());
            ilist = mg.getInstructionList();
        } else {
            ilist = new InstructionList();
            mg = new MethodGen(8, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<clinit>", this.className, ilist, this.clazz_.getConstantPool());
        }
        InstructionHandle ih = ilist.insert((CompoundInstruction)new PUSH(this.cpGen_, counterCount));
        ih = ilist.append(ih, (Instruction)new NEWARRAY(Type.INT));
        ih = ilist.append(ih, (Instruction)this.factory.createFieldAccess(this.className, "q$$q", (Type)new ArrayType((Type)Type.INT, 1), (short)179));
        ih = ilist.append(ih, (CompoundInstruction)new PUSH(this.cpGen_, 0));
        ih = ilist.append(ih, (Instruction)this.factory.createFieldAccess(this.className, "q$$qVer", (Type)Type.INT, (short)179));
        ih = ilist.append(ih, (CompoundInstruction)new PUSH(this.cpGen_, "org.quilt.QIC"));
        ih = ilist.append(ih, (Instruction)this.factory.createInvoke(this.className, "class$", (Type)new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, (short)184));
        ih = ilist.append(ih, (Instruction)InstructionConstants.DUP);
        ih = ilist.append(ih, (Instruction)this.factory.createFieldAccess(this.className, "class$QIC", (Type)new ObjectType("java.lang.Class"), (short)179));
        ih = ilist.append(ih, (Instruction)this.factory.createInvoke("java.lang.Class", "getClassLoader", (Type)new ObjectType("java.lang.ClassLoader"), Type.NO_ARGS, (short)182));
        ih = ilist.append(ih, (Instruction)this.factory.createCheckCast((ReferenceType)new ObjectType("org.quilt.cl.QuiltClassLoader")));
        ih = ilist.append(ih, (CompoundInstruction)new PUSH(this.cpGen_, "org.quilt.cover.stmt.StmtRegistry"));
        ih = ilist.append(ih, (Instruction)this.factory.createInvoke("org.quilt.cl.QuiltClassLoader", "getRegistry", (Type)new ObjectType("org.quilt.reg.QuiltRegistry"), new Type[]{Type.STRING}, (short)182));
        ih = ilist.append(ih, (Instruction)this.factory.createCheckCast((ReferenceType)new ObjectType("org.quilt.cover.stmt.StmtRegistry")));
        ih = ilist.append(ih, (Instruction)this.factory.createFieldAccess(this.className, "q$$qStmtReg", (Type)new ObjectType("org.quilt.cover.stmt.StmtRegistry"), (short)179));
        ih = ilist.append(ih, (Instruction)this.factory.createFieldAccess(this.className, "q$$qStmtReg", (Type)new ObjectType("org.quilt.cover.stmt.StmtRegistry"), (short)178));
        ih = ilist.append(ih, (CompoundInstruction)new PUSH(this.cpGen_, this.className));
        ih = ilist.append(ih, (Instruction)this.factory.createFieldAccess(this.className, "q$$q", (Type)new ArrayType((Type)Type.INT, 1), (short)178));
        ih = ilist.append(ih, (Instruction)this.factory.createInvoke("org.quilt.cover.stmt.StmtRegistry", "registerCounts", (Type)Type.INT, new Type[]{Type.STRING, new ArrayType((Type)Type.INT, 1)}, (short)182));
        ih = ilist.append(ih, (Instruction)this.factory.createFieldAccess(this.className, "q$$qID", (Type)Type.INT, (short)179));
        if (!this.clinitExists) {
            ih = ilist.append(ih, (Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        }
        ilist.setPositions();
        mg.setMaxStack();
        mg.setMaxLocals();
        boolean aborting = false;
        if (this.clinitExists) {
            this.clazz_.setMethodAt(mg.getMethod(), this.clinitIndex);
        } else {
            this.clazz_.addMethod(mg.getMethod());
        }
        if (!aborting) {
            int len = methodNames.size();
            String[] myNames = new String[len];
            int[] myEndCounts = new int[len];
            int k = 0;
            while (k < len) {
                myNames[k] = (String)methodNames.get(k);
                myEndCounts[k] = (Integer)methodEnds.get(k);
                ++k;
            }
            stmtReg.registerMethods(this.className, myNames, myEndCounts);
        }
        stmtReg.removeEphemera(this.className);
    }

    public String getName() {
        return name_;
    }

    public void setName(String name) {
        name_ = name;
    }
}

