/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cover.stmt;

import org.apache.bcel.Constants;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;
import org.quilt.cl.CodeVertex;
import org.quilt.cl.ControlFlowGraph;
import org.quilt.cl.GraphXformer;
import org.quilt.cover.stmt.ClassAction;
import org.quilt.cover.stmt.CounterVertex;
import org.quilt.cover.stmt.Ephemera;
import org.quilt.cover.stmt.StmtRegistry;
import org.quilt.graph.BinaryConnector;
import org.quilt.graph.Directed;
import org.quilt.graph.Edge;
import org.quilt.graph.Exit;
import org.quilt.graph.Vertex;
import org.quilt.graph.Visitor;
import org.quilt.graph.Walker;

public class GraphAction
implements GraphXformer {
    private static StmtRegistry stmtReg = null;
    private ClassGen clazz_ = null;
    private MethodGen method_ = null;
    private static String name_ = null;
    private InstructionFactory factory_;
    private ConstantPoolGen cpGen_;
    private int counterCount = 0;
    private ClassAction classAct_ = null;

    public GraphAction() {
    }

    public GraphAction(StmtRegistry reg) {
        stmtReg = reg;
        GraphAction.setName(this.getClass().getName());
    }

    public GraphAction(StmtRegistry reg, ClassAction classAct) {
        if (reg == null || classAct == null) {
            throw new IllegalArgumentException("null argument");
        }
        stmtReg = reg;
        this.classAct_ = classAct;
        GraphAction.setName(this.getClass().getName());
    }

    public void xform(ClassGen cg, MethodGen method, ControlFlowGraph cfg) {
        this.clazz_ = cg;
        this.method_ = method;
        this.cpGen_ = cg.getConstantPool();
        this.factory_ = new InstructionFactory(this.clazz_, this.cpGen_);
        String className = this.clazz_.getClassName();
        Ephemera eph = stmtReg.getEphemera(className);
        if (eph == null) {
            System.out.println("GraphAction.xform: eph is null!");
        }
        this.counterCount = eph.getCounterCount();
        int cfgSize = cfg.size();
        Walker walker = new Walker();
        walker.visit(cfg, new LampLighter());
        eph.setEndCount(method.getName(), this.counterCount);
    }

    public static String getName() {
        return name_;
    }

    public static void setName(String name) {
        name_ = name;
    }

    private class LampLighter
    implements Visitor,
    Constants,
    InstructionConstants {
        private ControlFlowGraph graph = null;

        public void discoverGraph(Directed g) {
            this.graph = (ControlFlowGraph)g;
        }

        public void discoverVertex(Vertex v) {
        }

        public void discoverEdge(Edge e) {
            Vertex source = e.getSource();
            Vertex target = e.getTarget();
            ControlFlowGraph srcGraph = (ControlFlowGraph)source.getGraph();
            ControlFlowGraph tgtGraph = (ControlFlowGraph)target.getGraph();
            if (tgtGraph != this.graph) {
                System.out.println("GraphAction.discoverEdge:\n  current graph is " + this.graph.getIndex() + " but edge is " + e);
            }
            boolean addingCounter = true;
            if (target instanceof CodeVertex && !(target instanceof CounterVertex) && !(source instanceof CounterVertex)) {
                Instruction srcConnInst = null;
                if (source instanceof CodeVertex && (srcConnInst = ((CodeVertex)source).getConnInst()) != null && srcConnInst instanceof GotoInstruction && source.getGraph() != tgtGraph) {
                    addingCounter = false;
                }
                if (srcGraph != this.graph) {
                    System.out.println("GraphAction.discoverEdge WARNING: graph index " + this.graph.getIndex() + "\n    but edge is " + e + " - not adding counter");
                    addingCounter = false;
                }
                if (addingCounter) {
                    CounterVertex cv = source instanceof Exit ? (CounterVertex)tgtGraph.insertCodeVertex(new CounterVertex(tgtGraph), e) : (CounterVertex)this.graph.insertCodeVertex(new CounterVertex(this.graph), e);
                    InstructionList ilist = cv.getInstructionList();
                    InstructionHandle ih = ilist.append((Instruction)GraphAction.this.factory_.createFieldAccess(GraphAction.this.clazz_.getClassName(), "q$$q", (Type)new ArrayType((Type)Type.INT, 1), (short)178));
                    ilist.append((CompoundInstruction)new PUSH(GraphAction.this.cpGen_, GraphAction.this.counterCount++));
                    ilist.append((Instruction)InstructionConstants.DUP2);
                    ilist.append((Instruction)InstructionConstants.IALOAD);
                    ilist.append((CompoundInstruction)new PUSH(GraphAction.this.cpGen_, 1));
                    ilist.append((Instruction)InstructionConstants.IADD);
                    ilist.append((Instruction)InstructionConstants.IASTORE);
                    if (source instanceof CodeVertex && srcConnInst != null) {
                        Edge otherEdge;
                        if (srcConnInst instanceof GotoInstruction) {
                            if (e != source.getEdge()) {
                                ((CodeVertex)source).moveGoto(cv);
                            }
                        } else if ((srcConnInst instanceof IfInstruction || srcConnInst instanceof JsrInstruction) && e == (otherEdge = ((BinaryConnector)source.getConnector()).getOtherEdge())) {
                            BranchInstruction bi = (BranchInstruction)srcConnInst;
                            InstructionHandle targ = bi.getTarget();
                            bi.setTarget(ih);
                            cv.setConnInst((Instruction)new GOTO(targ));
                            cv.makeBinary();
                            BinaryConnector bc = (BinaryConnector)cv.getConnector();
                            Vertex myTarget = bc.getTarget();
                            if (this.graph.getExit() == null) {
                                System.out.println("GRAPH HAS NULL EXIT");
                            }
                            bc.setTarget(this.graph.getExit());
                            bc.setOtherTarget(myTarget);
                        }
                    }
                }
            }
        }

        public void finishEdge(Edge e) {
        }

        public void finishVertex(Vertex v) {
        }

        public void finishGraph(Directed g) {
        }
    }
}

