/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cover.stmt;

import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.quilt.cl.ClassXformer;
import org.quilt.cl.GraphXformer;
import org.quilt.cl.MethodXformer;
import org.quilt.cl.QuiltClassLoader;
import org.quilt.cover.stmt.ClassAction;
import org.quilt.cover.stmt.Ephemera;
import org.quilt.cover.stmt.GraphAction;
import org.quilt.cover.stmt.MethodAction;
import org.quilt.cover.stmt.QIC;
import org.quilt.reg.QuiltRegistry;

public class StmtRegistry
extends QuiltRegistry {
    private static StmtRegistry INSTANCE = null;
    private Map methodNames = new Hashtable();
    private Map methodEnds = new Hashtable();
    private static int nextClassID = 0;
    private Map ephemera = new Hashtable();

    public static StmtRegistry getInstance() {
        return INSTANCE;
    }

    public StmtRegistry(QuiltClassLoader qcl) {
        super(qcl);
        INSTANCE = this;
        ClassAction classAct = new ClassAction(this);
        this.cxf = new ClassXformer[]{classAct};
        this.mxf = new MethodXformer[]{new MethodAction(this)};
        this.gxf = new GraphXformer[]{new GraphAction(this, classAct)};
        this.setTransformers();
    }

    public void reset() {
    }

    public String getReport() {
        StringBuffer sb = new StringBuffer().append("\n=========================\n").append("  QUILT COVERAGE REPORT \n");
        if (this.isEmpty()) {
            sb.append("* the registry is empty *\n");
        } else {
            Set keys = this.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                String[] name = (String[])i.next();
                int[] counts = (int[])this.get(name);
                int count = counts.length;
                String className = name[0];
                sb.append(className + ": " + count + " counters, " + this.getClassCoverage(className) + "% coverage\n    ");
                String[] methods = (String[])this.methodNames.get(className);
                if (methods == null) {
                    sb.append(" NULL\n");
                    continue;
                }
                int k = 0;
                while (k < methods.length) {
                    sb.append("    ").append(methods[k]).append("  ").append(this.getMethodCoverage(className, k)).append("% coverage\n");
                    ++k;
                }
            }
        }
        sb.append("=========================\n");
        return sb.toString();
    }

    int getClassCoverage(String className) {
        int nonZero = 0;
        int[] hitCounts = (int[])this.get(new String[]{className});
        if (hitCounts != null) {
            int k = 0;
            while (k < hitCounts.length) {
                if (hitCounts[k] > 0) {
                    ++nonZero;
                }
                ++k;
            }
            nonZero = nonZero * 100 / hitCounts.length;
        }
        return nonZero;
    }

    int getMethodCoverage(String className, int n) {
        int firstCounter;
        int nonZero = 0;
        int[] hitCounts = (int[])this.get(new String[]{className});
        int[] ends = (int[])this.methodEnds.get(className);
        if (n < 0 || n >= hitCounts.length) {
            throw new IllegalArgumentException("index out of range");
        }
        int counterCount = 0;
        int lastCounter = ends[n] - 1;
        int n2 = firstCounter = n == 0 ? 0 : ends[n - 1];
        if (hitCounts != null && ends != null) {
            int k = firstCounter;
            while (k <= lastCounter) {
                ++counterCount;
                if (hitCounts[k] > 0) {
                    ++nonZero;
                }
                ++k;
            }
            if (counterCount > 0) {
                nonZero = nonZero * 100 / counterCount;
            }
        }
        return nonZero;
    }

    public int getClassID(String className) {
        int classID = -1;
        try {
            Field qField = Class.forName(className).getField("q$$qID");
            classID = qField.getInt(qField);
        }
        catch (Exception e) {
            System.out.println("StmtRegistry.getClassID(" + className + ") failed - " + e);
        }
        return classID;
    }

    public int[] getCounts(String className) {
        int[] counts = null;
        try {
            counts = (int[])this.get(new String[]{className});
        }
        catch (Exception e) {
            System.out.println("StmtRegistry.getCounts (" + className + ") failed - " + e);
        }
        return counts;
    }

    public int registerCounts(String className, int[] counts) {
        int classID = -1;
        try {
            this.put(new String[]{className}, counts);
            classID = nextClassID++;
        }
        catch (Exception e) {
            System.out.println("StmtRegistry.registerCounts for " + className + ", q$$q) failed - " + e);
        }
        return classID;
    }

    public void registerMethods(String className, String[] methods, int[] endCounts) {
        if (className == null || methods == null || endCounts == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.methodNames.put(className, methods);
        this.methodEnds.put(className, endCounts);
    }

    public int getQuiltVersion(String className) {
        int quiltVersion = -1;
        try {
            Field qField = Class.forName(className).getField("q$$qVer");
            quiltVersion = qField.getInt(qField);
        }
        catch (Exception e) {
            System.out.println("StmtRegistry.getClassID(" + className + ") failed - " + e);
        }
        return quiltVersion;
    }

    Ephemera getEphemera(String className) {
        if (this.ephemera.containsKey(className)) {
            return (Ephemera)this.ephemera.get(className);
        }
        return null;
    }

    boolean putEphemera(String className, Ephemera eph) {
        if (this.ephemera.containsKey(className)) {
            return false;
        }
        this.ephemera.put(className, eph);
        return true;
    }

    Ephemera removeEphemera(String className) {
        return (Ephemera)this.ephemera.remove(className);
    }

    public int registerClass(String name, QIC junk) {
        System.out.println("**************************\nQCL.registerClass " + name + "\n**************************");
        return 52;
    }
}

