/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.framework;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.quilt.reports.FmtSelector;

public class QuiltTest
implements Cloneable {
    private String name = null;
    private boolean checkCoverage = false;
    private String checkExcludes;
    private String checkIncludes;
    private String errorProperty;
    private String failureProperty;
    private boolean filtertrace = true;
    private boolean fork = false;
    private Vector formatters = new Vector();
    private boolean haltOnError = false;
    private boolean haltOnFailure = false;
    private String ifProperty = null;
    private boolean mockTestRun = false;
    private String outfile = null;
    private Properties props = new Properties();
    private boolean showOutput = false;
    private File todir = null;
    private String unlessProperty = null;
    private long errors = 0L;
    private long failures = 0L;
    private long runs = 0L;
    private long runTime = 0L;

    public QuiltTest() {
    }

    public QuiltTest(String name) {
        this.name = name;
    }

    public void setCounts(long runs, long failures, long errors) {
        this.errors = errors;
        this.failures = failures;
        this.runs = runs;
    }

    public long errorCount() {
        return this.errors;
    }

    public long failureCount() {
        return this.failures;
    }

    public long runCount() {
        return this.runs;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Hashtable val) {
        Enumeration e = val.keys();
        this.props.clear();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this.props.put(key, val.get(key));
        }
    }

    public long getRunTime() {
        return this.runTime;
    }

    public void setRunTime(long val) {
        this.runTime = val;
    }

    public void addFormattersTo(Vector v) {
        int j = 0;
        while (j < this.formatters.size()) {
            v.addElement(this.formatters.elementAt(j));
            ++j;
        }
    }

    public boolean getCheckCoverage() {
        return this.checkCoverage;
    }

    public void setCheckCoverage(boolean b) {
        this.checkCoverage = b;
    }

    public String getCheckExcludes() {
        return this.checkExcludes;
    }

    public String[] getCheckExcludesArray() {
        String[] val = null;
        if (this.checkExcludes != null) {
            val = this.checkExcludes.split(",");
        }
        return val;
    }

    public void setCheckExcludes(String val) {
        this.checkExcludes = val;
    }

    public String getCheckIncludes() {
        return this.checkIncludes;
    }

    public String[] getCheckIncludesArray() {
        String[] val = null;
        if (this.checkIncludes != null) {
            val = this.checkIncludes.split(",");
        }
        return val;
    }

    public void setCheckIncludes(String val) {
        this.checkIncludes = val;
    }

    public String getErrorProperty() {
        return this.errorProperty;
    }

    public void setErrorProperty(String eP) {
        this.errorProperty = eP;
    }

    public String getFailureProperty() {
        return this.failureProperty;
    }

    public void setFailureProperty(String fP) {
        this.failureProperty = fP;
    }

    public boolean getFiltertrace() {
        return this.filtertrace;
    }

    public void setFiltertrace(boolean b) {
        this.filtertrace = b;
    }

    public boolean getFork() {
        return this.fork;
    }

    public void setFork(boolean b) {
        this.fork = b;
    }

    public void addFormatter(FmtSelector elem) {
        this.formatters.addElement(elem);
    }

    public Vector getFormatters() {
        return this.formatters;
    }

    public boolean getHaltOnError() {
        return this.haltOnError;
    }

    public void setHaltOnError(boolean b) {
        this.haltOnError = b;
    }

    public boolean getHaltOnFailure() {
        return this.haltOnFailure;
    }

    public void setHaltOnFailure(boolean b) {
        this.haltOnFailure = b;
    }

    public String getIfProperty() {
        return this.ifProperty;
    }

    public void setIf(String name) {
        this.ifProperty = name;
    }

    public boolean getMockTestRun() {
        return this.mockTestRun;
    }

    public void setMockTestRun(boolean b) {
        this.mockTestRun = b;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getOutfile() {
        return this.outfile;
    }

    public void setOutfile(String val) {
        this.outfile = val;
    }

    public boolean getShowOutput() {
        return this.showOutput;
    }

    public void setShowOutput(boolean b) {
        this.showOutput = b;
    }

    public String getTodir() {
        if (this.todir != null) {
            return this.todir.getAbsolutePath();
        }
        return null;
    }

    public void setTodir(File dir) {
        this.todir = dir;
    }

    public String getUnlessProperty() {
        return this.unlessProperty;
    }

    public void setUnless(String name) {
        this.unlessProperty = name;
    }

    public Object clone() {
        QuiltTest t = new QuiltTest();
        t.name = this.name;
        t.checkCoverage = this.checkCoverage;
        t.checkExcludes = this.checkExcludes;
        t.checkIncludes = this.checkIncludes;
        t.errorProperty = this.errorProperty;
        t.failureProperty = this.failureProperty;
        t.filtertrace = this.filtertrace;
        t.formatters = (Vector)this.formatters.clone();
        t.fork = this.fork;
        t.haltOnError = this.haltOnError;
        t.haltOnFailure = this.haltOnFailure;
        t.ifProperty = this.ifProperty;
        t.mockTestRun = this.mockTestRun;
        t.outfile = this.outfile;
        t.showOutput = this.showOutput;
        t.todir = this.todir;
        t.unlessProperty = this.unlessProperty;
        Properties props = this.getProperties();
        if (props != null) {
            t.setProperties((Properties)props.clone());
        }
        return t;
    }

    public String toString() {
        String pStr;
        String fmtStr = "";
        int i = 0;
        while (i < this.formatters.size()) {
            fmtStr = fmtStr + this.formatters.elementAt(i) + "  ";
            ++i;
        }
        if (this.props != null) {
            pStr = "";
            Enumeration<Object> e = this.props.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = this.props.getProperty(name);
                pStr = pStr + "\n      (" + name + " --> " + value + ")";
            }
        } else {
            pStr = "<none>";
        }
        String s = "    test name:       " + this.name + "\n    checkCoverage:   " + this.checkCoverage + "\n    checkExcludes:   " + (this.checkExcludes == null ? "" : this.checkExcludes) + "\n    checkIncludes:   " + (this.checkIncludes == null ? "" : this.checkIncludes) + "\n    errorProperty:   " + this.errorProperty + "\n    failureProperty: " + this.failureProperty + "\n    filtertrace:     " + this.filtertrace + "\n    fork:            " + this.fork + "\n    formatters:      " + fmtStr + "\n    haltOnError:     " + this.haltOnError + "\n    haltOnFailure:   " + this.haltOnFailure + "\n    ifProperty:      " + this.ifProperty + "\n    mockTestRun:     " + this.mockTestRun + "\n    outfile:         " + this.outfile + "\n    showOutput:      " + this.showOutput + "\n    todir:           " + this.todir + "\n    unlessProperty:  " + this.unlessProperty + "\n    errors:          " + this.errors + "\n    failures:        " + this.failures + "\n    runs:            " + this.runs + "\n    other properties:" + pStr;
        return s;
    }

    public boolean runMe(Project p) {
        if (this.ifProperty != null && p.getProperty(this.ifProperty) == null) {
            return false;
        }
        return this.unlessProperty == null || p.getProperty(this.ifProperty) == null;
    }
}

