/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.frontend.ant;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.quilt.cl.QuiltClassLoader;
import org.quilt.framework.QuiltTest;
import org.quilt.frontend.ant.TaskControl;
import org.quilt.reports.FmtSelector;
import org.quilt.reports.SummaryFormatter;
import org.quilt.runner.BaseTestRunner;
import org.quilt.runner.Runner;

public class CallTest {
    private Project project = null;
    private Task task = null;
    private TaskControl tc = null;
    private QuiltTest qt = null;
    private CommandlineJava cmdLine = null;
    private Runner runner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execTest(QuiltTest test, TaskControl tc) throws BuildException {
        CommandlineJava.SysProperties sysProperties;
        QuiltTest qt = (QuiltTest)test.clone();
        this.tc = tc;
        this.task = tc.getTask();
        this.project = this.task.getProject();
        boolean usingQuilt = tc.getLoader() != null && qt.getCheckCoverage() && qt.getCheckIncludes() != null;
        this.cmdLine = (CommandlineJava)tc.getCommandline().clone();
        qt.setProperties(this.project.getProperties());
        if (tc.getDir() != null) {
            this.task.log("Dir attribute ignored, running in the same virtual machine", 1);
        }
        if (tc.getNewEnvironment() || null != tc.getEnv().getVariables()) {
            this.task.log("Changes to environment variables are ignored, running in the same virtual machine.", 1);
        }
        if ((sysProperties = this.cmdLine.getSystemProperties()) != null) {
            sysProperties.setSystem();
        }
        AntClassLoader antLoader = null;
        QuiltClassLoader quiltLoader = tc.getLoader();
        try {
            Path classpath;
            this.task.log("Using System properties " + System.getProperties(), 3);
            Path userClasspath = this.cmdLine.getClasspath();
            Path path = classpath = userClasspath == null ? null : (Path)userClasspath.clone();
            if (usingQuilt) {
                String pathForQuilt = classpath == null ? null : classpath.toString();
                quiltLoader.setClassPath(pathForQuilt);
                quiltLoader.setIncluded(qt.getCheckIncludes());
                quiltLoader.setExcluded(qt.getCheckExcludes());
            } else if (classpath != null) {
                if (tc.getIncludeAntRuntime()) {
                    this.task.log("Adding " + tc.getAntRuntimeClasses() + " to CLASSPATH", 3);
                    classpath.append(tc.getAntRuntimeClasses());
                }
                antLoader = new AntClassLoader(null, this.project, classpath, false);
                this.task.log("Using CLASSPATH " + antLoader.getClasspath(), 3);
                antLoader.addSystemPackageRoot("junit");
            }
            this.runner = usingQuilt ? new BaseTestRunner(qt, quiltLoader) : new BaseTestRunner(qt, (ClassLoader)antLoader);
            if (tc.getSummary()) {
                this.task.log("Running " + qt.getName(), 2);
                SummaryFormatter fmt = new SummaryFormatter();
                fmt.setWithOutAndErr("withoutanderr".equals(tc.getSummaryValue()));
                fmt.setOutput(tc.getDefaultOutput());
                this.runner.addFormatter(fmt);
            }
            FmtSelector[] selectors = tc.mergeSelectors(qt);
            int i = 0;
            while (i < selectors.length) {
                FmtSelector fs = selectors[i];
                File outFile = tc.getOutput(fs, qt);
                if (outFile != null) {
                    fs.setOutfile(outFile);
                } else {
                    fs.setOutput(tc.getDefaultOutput());
                }
                this.runner.addFormatter(fs.createFormatter());
                ++i;
            }
            this.runner.run();
            int n = this.runner.getRetCode();
            return n;
        }
        finally {
            if (sysProperties != null) {
                sysProperties.restoreSystem();
            }
            if (antLoader != null) {
                antLoader.resetThreadContextLoader();
            }
        }
    }
}

