/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.frontend.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.util.FileUtils;
import org.quilt.framework.QuiltTest;
import org.quilt.frontend.ant.TaskControl;
import org.quilt.reports.FmtSelector;
import org.quilt.reports.Formatter;

public class ForkTest {
    private Project project = null;
    private Task task = null;
    private TaskControl tc = null;
    private QuiltTest qt = null;
    private boolean mockery = false;
    private boolean checkingCoverage = false;

    protected int execTest(QuiltTest qt, TaskControl tc, ExecuteWatchdog watchdog) throws BuildException {
        int retVal;
        String[] environment;
        this.tc = tc;
        this.task = tc.getTask();
        this.project = this.task.getProject();
        this.mockery = qt.getMockTestRun();
        this.checkingCoverage = qt.getCheckCoverage();
        CommandlineJava cmd = (CommandlineJava)tc.getCommandline().clone();
        if (this.mockery) {
            this.task.log("ForkTest: setting class name to  MockTestRunner");
            cmd.setClassname("org.quilt.textui.MockTestRunner");
        } else {
            cmd.setClassname("org.quilt.textui.TestRunner");
        }
        cmd.createArgument().setValue(qt.getName());
        cmd.createArgument().setValue("checkCoverage=" + this.checkingCoverage);
        if (this.checkingCoverage) {
            String excluded = qt.getCheckExcludes();
            String included = qt.getCheckIncludes();
            if (excluded != null) {
                cmd.createArgument().setValue("checkExcludes=" + excluded);
            }
            if (included != null) {
                cmd.createArgument().setValue("checkIncludes=" + included);
            }
        }
        cmd.createArgument().setValue("filtertrace=" + qt.getFiltertrace());
        cmd.createArgument().setValue("haltOnError=" + qt.getHaltOnError());
        cmd.createArgument().setValue("haltOnFailure=" + qt.getHaltOnFailure());
        if (tc.getIncludeAntRuntime()) {
            this.task.log("Adding " + tc.getAntRuntimeClasses() + " to CLASSPATH", 3);
            cmd.createClasspath(this.project).createPath().append(tc.getAntRuntimeClasses());
        }
        if (tc.getSummary()) {
            this.task.log("Running " + qt.getName(), 2);
            cmd.createArgument().setValue("formatter=org.quilt.reports.SummaryFormatter");
        }
        cmd.createArgument().setValue("showoutput=" + String.valueOf(qt.getShowOutput()));
        StringBuffer formatterArg = new StringBuffer(256);
        FmtSelector[] selectors = tc.mergeSelectors(qt);
        int i = 0;
        while (i < selectors.length) {
            FmtSelector fs = selectors[i];
            formatterArg.append("formatter=");
            formatterArg.append(fs.getClassname());
            File outFile = tc.getOutput(fs, qt);
            if (outFile != null) {
                formatterArg.append(",");
                formatterArg.append(outFile);
            }
            cmd.createArgument().setValue(formatterArg.toString());
            formatterArg.setLength(0);
            ++i;
        }
        File propsFile = FileUtils.newFileUtils().createTempFile("quilt", ".properties", this.project.getBaseDir());
        cmd.createArgument().setValue("propsfile=" + propsFile.getAbsolutePath());
        Hashtable p = this.project.getProperties();
        Properties props = new Properties();
        Enumeration e = p.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            props.put(key, p.get(key));
        }
        try {
            FileOutputStream outstream = new FileOutputStream(propsFile);
            props.save(outstream, "Ant QuiltTask generated properties file");
            outstream.close();
        }
        catch (IOException e2) {
            propsFile.delete();
            throw new BuildException("Error creating temporary properties file.", (Throwable)e2, this.task.getLocation());
        }
        Execute forker = new Execute((ExecuteStreamHandler)new LogStreamHandler(this.task, 2, 1), watchdog);
        forker.setCommandline(cmd.getCommandline());
        forker.setAntRun(this.project);
        if (tc.getDir() != null) {
            forker.setWorkingDirectory(tc.getDir());
        }
        if ((environment = tc.getEnv().getVariables()) != null) {
            int i2 = 0;
            while (i2 < environment.length) {
                this.task.log("Setting environment variable: " + environment[i2], 3);
                ++i2;
            }
        }
        forker.setNewenvironment(tc.getNewEnvironment());
        forker.setEnvironment(environment);
        this.task.log(cmd.describeCommand(), 3);
        try {
            retVal = forker.execute();
        }
        catch (IOException e3) {
            throw new BuildException("Error forking test", (Throwable)e3, this.task.getLocation());
        }
        finally {
            if (watchdog != null && watchdog.killedProcess()) {
                this.logTimeout(selectors, qt);
                retVal = 1;
            }
            if (!propsFile.delete()) {
                throw new BuildException("Error deleting temporary properties file.");
            }
        }
        return retVal;
    }

    private void logTimeout(FmtSelector[] selectors, QuiltTest qt) {
        int i = 0;
        while (i < selectors.length) {
            FmtSelector fs = selectors[i];
            File outFile = this.tc.getOutput(fs, qt);
            Formatter formatter = fs.createFormatter();
            if (outFile != null && formatter != null) {
                try {
                    FileOutputStream out = new FileOutputStream(outFile);
                    formatter.setOutput(out);
                    formatter.startTestSuite(qt);
                    qt.setCounts(0L, 0L, 1L);
                    Test t = new Test(){

                        public int countTestCases() {
                            return 0;
                        }

                        public void run(TestResult r) {
                            throw new AssertionFailedError("Timeout during test run.");
                        }
                    };
                    formatter.startTest(t);
                    formatter.addError(t, (Throwable)new AssertionFailedError("Timeout during test run."));
                    formatter.endTestSuite(qt);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }
}

