/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.frontend.ant;

import java.io.File;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.quilt.cl.QuiltClassLoader;
import org.quilt.cover.stmt.StmtRegistry;
import org.quilt.framework.QuiltTest;
import org.quilt.frontend.ant.BatchTest;
import org.quilt.frontend.ant.MockExec;
import org.quilt.frontend.ant.Scheduler;
import org.quilt.frontend.ant.SummaryAttribute;
import org.quilt.frontend.ant.TaskControl;
import org.quilt.frontend.ant.TestExec;
import org.quilt.reports.FmtSelector;

public class QuiltTask
extends Task {
    private Scheduler sch = null;
    private TaskControl tc = null;
    private boolean includeAntRuntime = true;
    private Path antRuntimeClasses = null;
    private QuiltTest qt = new QuiltTest();
    private MockExec mockE = null;
    private TestExec testE = null;
    private boolean mockery = false;
    private boolean firstTimeThrough = true;

    public void setCheckCoverage(boolean b) {
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setCheckCoverage(b);
        }
    }

    public void setCheckExcludes(String s) {
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setCheckExcludes(s);
        }
    }

    public void setCheckIncludes(String s) {
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setCheckIncludes(s);
        }
    }

    public void setErrorProperty(String propertyName) {
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setErrorProperty(propertyName);
        }
    }

    public void setFailureProperty(String propertyName) {
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setFailureProperty(propertyName);
        }
    }

    public void setFiltertrace(boolean b) {
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setFiltertrace(b);
        }
    }

    public void setFork(boolean b) {
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setFork(b);
        }
    }

    public void setHaltOnError(boolean b) {
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setHaltOnError(b);
        }
    }

    public void setHaltOnFailure(boolean b) {
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setHaltOnFailure(b);
        }
    }

    public void setMockTestRun(boolean b) {
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setMockTestRun(b);
        }
    }

    public void setShowOutput(boolean b) {
        this.tc.setShowOutput(b);
        this.sch.schedule();
        while ((this.qt = this.sch.nextTest()) != null) {
            this.qt.setShowOutput(b);
        }
    }

    public BatchTest createBatchTest() {
        BatchTest bt = new BatchTest(this.getProject());
        this.sch.addBatchTest(bt);
        return bt;
    }

    public Path createClasspath() {
        return this.tc.createClasspath();
    }

    public void setDir(File dir) {
        this.tc.setDir(dir);
    }

    public void addEnv(Environment.Variable var) {
        this.tc.addEnv(var);
    }

    public void addFormatter(FmtSelector fe) {
        this.tc.addFormatter(fe);
    }

    public void setIncludeAntRuntime(boolean b) {
        this.tc.setIncludeAntRuntime(b);
    }

    public void setJvm(String value) {
        this.tc.setJvm(value);
    }

    public Commandline.Argument createJvmarg() {
        return this.tc.createJvmarg();
    }

    public void setMaxmemory(String max) {
        this.tc.setMaxmemory(max);
    }

    public void setMockExec(boolean b) {
        this.tc.setMockExec(b);
    }

    public void setNewenvironment(boolean b) {
        this.tc.setNewEnvironment(b);
    }

    public void setPrintsummary(String sValue) {
        SummaryAttribute sa = new SummaryAttribute(sValue);
        this.tc.setSummary(sa.asBoolean());
        this.tc.setSummaryValue(sa.getValue());
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.tc.addSysproperty(sysp);
    }

    public void addTest(QuiltTest qt) {
        this.sch.addTest(qt);
    }

    public void setTimeout(Long t) {
        this.tc.setTimeout(t);
    }

    public QuiltTask() throws Exception {
        this.sch = new Scheduler(this);
        this.tc = this.sch.getTaskControl();
    }

    private void addCPEs() {
        this.mockery = this.tc.getMockExec();
        if (this.mockery) {
            this.mockE = new MockExec();
        } else {
            this.testE = new TestExec();
        }
        this.addClasspathEntry("/junit/framework/TestCase.class");
        this.addClasspathEntry("/org/apache/tools/ant/Task.class");
        this.addClasspathEntry("/org/quilt/runner/BaseTestRunner.class");
    }

    public void init() {
        this.antRuntimeClasses = new Path(this.getProject());
    }

    public void execute() throws BuildException {
        QuiltClassLoader qcl;
        StmtRegistry stmtReg;
        if (this.firstTimeThrough) {
            this.firstTimeThrough = false;
            this.addCPEs();
            this.sch.unbatch();
        }
        this.sch.schedule();
        Path quiltClassPath = this.tc.getCommandline().getClasspath();
        if (this.tc.getIncludeAntRuntime()) {
            quiltClassPath.append(this.tc.getAntRuntimeClasses());
        }
        if ((stmtReg = (StmtRegistry)(qcl = new QuiltClassLoader(QuiltClassLoader.cpToURLs(this.tc.getCommandline().getClasspath().toString()), ((Object)((Object)this)).getClass().getClassLoader(), null, null, null)).addQuiltRegistry("org.quilt.cover.stmt.StmtRegistry")) == null) {
            System.out.println("QuiltTask.execute: org.quilt.cover.stmt.StmtRegistry not found\n  classpath error?");
        }
        this.tc.setLoader(qcl);
        while ((this.qt = this.sch.nextTest()) != null) {
            if (this.tc.getMockExec()) {
                this.mockE.run(this.qt, this.tc);
                continue;
            }
            if (!this.qt.runMe(this.getProject())) continue;
            this.testE.execute(this.qt, this.tc);
        }
        if (stmtReg != null) {
            System.out.println(stmtReg.getReport());
        } else {
            System.out.println("QuiltTask.execute: after running tests, stmtReg is null");
        }
    }

    protected void addClasspathEntry(String resource) {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        if (url != null) {
            String u = url.toString();
            if (u.startsWith("jar:file:")) {
                int pling = u.indexOf("!");
                String jarName = u.substring(9, pling);
                this.log("Found " + jarName, 4);
                this.antRuntimeClasses.createPath().setLocation(new File(new File(jarName).getAbsolutePath()));
            } else if (u.startsWith("file:")) {
                int tail = u.indexOf(resource);
                String dirName = u.substring(5, tail);
                this.log("Found " + dirName, 4);
                this.antRuntimeClasses.createPath().setLocation(new File(new File(dirName).getAbsolutePath()));
            } else {
                this.log("Don't know how to handle resource URL " + u, 4);
            }
        } else {
            this.log("Couldn't find " + resource, 4);
        }
    }

    public void handleTheOutput(String line) {
        super.handleOutput(line);
    }

    public void handleTheFlush(String line) {
        super.handleFlush(line);
    }

    public void handleTheErrorOutput(String line) {
        super.handleErrorOutput(line);
    }

    public void handleTheErrorFlush(String line) {
        super.handleErrorFlush(line);
    }
}

