/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.frontend.ant;

import java.util.Vector;
import org.quilt.framework.QuiltTest;
import org.quilt.frontend.ant.BatchTest;
import org.quilt.frontend.ant.QuiltTask;
import org.quilt.frontend.ant.TaskControl;

public class Scheduler {
    private QuiltTask task = null;
    private TaskControl tc = null;
    private boolean batched = true;
    private Vector tests = new Vector();
    private int testIndex = 0;
    private Vector batchTests = new Vector();
    private int batchIndex = 0;
    private QuiltTest modelTest = new QuiltTest();

    public Scheduler(QuiltTask t) {
        this.task = t;
        this.tc = new TaskControl(this.task);
    }

    public void addBatchTest(BatchTest bt) {
        this.task.log("--> Scheduler.addBatchTest", 3);
        this.batchTests.addElement(bt);
    }

    public void addTest(QuiltTest test) {
        this.task.log("--> Scheduler.addTest", 3);
        this.tests.addElement(test);
    }

    public void schedule() {
        this.testIndex = 0;
        this.batchIndex = 0;
        this.task.log("\n===========================================================\n--> Scheduler.schedule: there are " + this.tests.size() + " tests and " + this.batchTests.size() + " batch tests" + "\n===========================================================\n", 4);
    }

    public QuiltTest nextTest() {
        if (this.testIndex < this.tests.size()) {
            return (QuiltTest)this.tests.elementAt(this.testIndex++);
        }
        if (this.batchIndex < this.batchTests.size()) {
            return (BatchTest)this.batchTests.elementAt(this.batchIndex++);
        }
        return null;
    }

    public void unbatch() {
        this.task.log("--> Scheduler.unbatch", 3);
        int i = 0;
        while (i < this.batchTests.size()) {
            ((BatchTest)this.batchTests.elementAt(i)).unbatch(this);
            ++i;
        }
        this.batched = false;
        this.batchTests = new Vector();
    }

    public TaskControl getTaskControl() {
        return this.tc;
    }
}

