/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.frontend.ant;

import java.io.File;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.quilt.cl.QuiltClassLoader;
import org.quilt.framework.QuiltTest;
import org.quilt.frontend.ant.QuiltTask;
import org.quilt.frontend.ant.SummaryAttribute;
import org.quilt.reports.FmtSelector;
import org.quilt.runner.Runner;

public class TaskControl {
    private CommandlineJava commandline = new CommandlineJava();
    private Environment env = new Environment();
    private QuiltTask task;
    private File dir = null;
    private Vector formatters = new Vector();
    private boolean includeAntRuntime = true;
    private boolean mockExec = false;
    private boolean newEnvironment = false;
    private boolean showOutput = false;
    private boolean summary = false;
    private Vector tests = new Vector();
    private Long timeout = null;
    private Path antRuntimeClasses = null;
    private Runner runner = null;
    private String summaryValue = "";
    protected QuiltClassLoader loader = null;

    private TaskControl() {
    }

    public TaskControl(QuiltTask t) {
        this.task = t;
    }

    public void setAntRuntimeClasses(Path p) {
        this.antRuntimeClasses = p;
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.task.getProject()).createPath();
    }

    public void setCommandline(CommandlineJava cmd) {
        this.commandline = cmd;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public void addFormatter(FmtSelector fs) {
        this.formatters.addElement(fs);
    }

    public void setFormatters(Vector v) {
        this.formatters = v;
    }

    public void setIncludeAntRuntime(boolean b) {
        this.includeAntRuntime = b;
    }

    public void setJvm(String value) {
        this.commandline.setVm(value);
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void setLoader(QuiltClassLoader qcl) {
        this.loader = qcl;
    }

    public void setMaxmemory(String max) {
        this.commandline.setMaxmemory(max);
    }

    public void setMockExec(boolean b) {
        this.mockExec = b;
    }

    public void setNewEnvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public void setPrintsummary(SummaryAttribute value) {
        this.summaryValue = value.getValue();
        this.summary = value.asBoolean();
    }

    public void setRunner(Runner r) {
        this.runner = r;
    }

    public void setShowOutput(boolean b) {
        this.showOutput = b;
    }

    public void setSummary(boolean b) {
        this.summary = b;
    }

    public void setSummaryValue(String s) {
        this.summaryValue = s;
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.commandline.addSysproperty(sysp);
    }

    public void addTest(QuiltTest t) {
        this.tests.addElement(t);
    }

    public void setTests(Vector v) {
        this.tests = v;
    }

    public void setTask(QuiltTask t) {
        this.task = t;
    }

    public void setTimeout(Long value) {
        this.timeout = value;
    }

    public CommandlineJava getCommandline() {
        return this.commandline;
    }

    public File getDir() {
        return this.dir;
    }

    public Environment getEnv() {
        return this.env;
    }

    public Vector getFormatters() {
        return this.formatters;
    }

    public boolean getIncludeAntRuntime() {
        return this.includeAntRuntime;
    }

    public QuiltClassLoader getLoader() {
        return this.loader;
    }

    public boolean getMockExec() {
        return this.mockExec;
    }

    public boolean getNewEnvironment() {
        return this.newEnvironment;
    }

    public boolean getSummary() {
        return this.summary;
    }

    public Task getTask() {
        return this.task;
    }

    public Vector getTests() {
        return this.tests;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public Path getAntRuntimeClasses() {
        return this.antRuntimeClasses;
    }

    public Runner getRunner() {
        return this.runner;
    }

    public String getSummaryValue() {
        return this.summaryValue;
    }

    void handleOutput(String line) {
        if (this.runner != null) {
            this.runner.handleOutput(line);
            if (this.showOutput) {
                this.task.handleTheOutput(line);
            }
        } else {
            this.task.handleTheOutput(line);
        }
    }

    void handleFlush(String line) {
        if (this.runner != null) {
            this.runner.handleFlush(line);
            if (this.showOutput) {
                this.task.handleTheFlush(line);
            }
        } else {
            this.task.handleTheFlush(line);
        }
    }

    void handleErrorOutput(String line) {
        if (this.runner != null) {
            this.runner.handleErrorOutput(line);
            if (this.showOutput) {
                this.task.handleTheErrorOutput(line);
            }
        } else {
            this.task.handleTheErrorOutput(line);
        }
    }

    void handleErrorFlush(String line) {
        if (this.runner != null) {
            this.runner.handleErrorFlush(line);
            if (this.showOutput) {
                this.task.handleTheErrorFlush(line);
            }
        } else {
            this.task.handleTheErrorFlush(line);
        }
    }

    OutputStream getDefaultOutput() {
        return new LogOutputStream((Task)this.task, 2);
    }

    FmtSelector[] mergeSelectors(QuiltTest test) {
        Vector fsVector = (Vector)this.getFormatters().clone();
        test.addFormattersTo(fsVector);
        Object[] fsArray = new FmtSelector[fsVector.size()];
        fsVector.copyInto(fsArray);
        return fsArray;
    }

    File getOutput(FmtSelector fs, QuiltTest test) {
        if (fs.getUseFile()) {
            String filename = test.getOutfile() + fs.getExtension();
            File destFile = new File(test.getTodir(), filename);
            String absFilename = destFile.getAbsolutePath();
            return this.task.getProject().resolveFile(absFilename);
        }
        return null;
    }

    ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout.longValue());
    }

    public boolean equals(TaskControl tc2) {
        if (this == tc2) {
            return true;
        }
        return this.formatters.equals(tc2.getFormatters()) && this.tests.equals(tc2.getTests()) && this.task == tc2.getTask() && this.commandline == tc2.getCommandline() && this.dir == tc2.getDir() && this.includeAntRuntime == tc2.getIncludeAntRuntime() && this.loader == tc2.getLoader() && this.mockExec == tc2.getMockExec() && this.newEnvironment == tc2.getNewEnvironment() && this.summary == tc2.getSummary() && this.timeout == tc2.getTimeout() && this.antRuntimeClasses == tc2.getAntRuntimeClasses() && this.runner == tc2.getRunner() && this.summaryValue.equals(tc2.getSummaryValue());
    }

    public Object clone() {
        TaskControl tc2 = new TaskControl();
        tc2.setTask(this.task);
        tc2.setCommandline(this.commandline);
        tc2.setFormatters((Vector)this.formatters.clone());
        tc2.setTests((Vector)this.tests.clone());
        tc2.setDir(this.dir);
        tc2.setIncludeAntRuntime(this.includeAntRuntime);
        tc2.setLoader(this.loader);
        tc2.setMockExec(this.mockExec);
        tc2.setNewEnvironment(this.newEnvironment);
        tc2.setSummary(this.summary);
        tc2.setTimeout(this.timeout);
        tc2.setAntRuntimeClasses(this.antRuntimeClasses);
        tc2.setRunner(this.runner);
        tc2.setSummaryValue(this.summaryValue);
        return tc2;
    }

    public String toString() {
        String f = "";
        int i = 0;
        while (i < this.formatters.size()) {
            f = f + this.formatters.elementAt(i) + " ";
            ++i;
        }
        String s = "    task:           " + this.task.getTaskName() + "\n    antRuntimeClasses: " + this.antRuntimeClasses + "\n    commandline:    " + "\n      as string:    " + this.commandline + "\n      classname:    " + this.commandline.getClassname() + "\n      classpath:    " + this.commandline.getClasspath() + "\n    dir:            " + this.dir + "\n    includeAntRuntime: " + this.includeAntRuntime + "\n    mockExec:       " + this.mockExec + "\n    newEnvironment: " + this.newEnvironment + "\n    runner:         " + this.runner + "\n    summary:        " + this.summary + "\n    summaryValue:   " + this.summaryValue + "\n    timeout:        " + this.timeout + "\n    formatters:     " + f + "\n ---------------------------------------------\n";
        return s;
    }
}

