/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.frontend.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.quilt.framework.QuiltTest;
import org.quilt.frontend.ant.CallTest;
import org.quilt.frontend.ant.ForkTest;
import org.quilt.frontend.ant.TaskControl;

public class TestExec {
    private Project project = null;
    private Task task = null;
    private TaskControl tc = null;
    private QuiltTest qt = null;

    protected void execute(QuiltTest arg, TaskControl tc) {
        boolean failureOccurredHere;
        QuiltTest test = (QuiltTest)arg.clone();
        this.tc = tc;
        this.task = tc.getTask();
        this.project = this.task.getProject();
        if (test.getTodir() == null) {
            test.setTodir(this.project.resolveFile("."));
        }
        if (test.getOutfile() == null) {
            test.setOutfile("TEST-" + test.getName());
        }
        int exitValue = 2;
        boolean timedOut = false;
        if (!test.getFork()) {
            CallTest ct = new CallTest();
            exitValue = ct.execTest(test, tc);
        } else {
            ForkTest ft = new ForkTest();
            ExecuteWatchdog watchdog = tc.createWatchdog();
            exitValue = ft.execTest(test, tc, watchdog);
            if (watchdog != null) {
                timedOut = watchdog.killedProcess();
            }
        }
        boolean errorOccurredHere = exitValue == 2;
        boolean bl = failureOccurredHere = exitValue != 0;
        if (failureOccurredHere) {
            if (errorOccurredHere && test.getHaltOnError() || failureOccurredHere && test.getHaltOnFailure()) {
                throw new BuildException("Test " + test.getName() + " failed" + (timedOut ? " (timeout)" : ""), this.task.getLocation());
            }
            this.task.log("TEST " + test.getName() + " FAILED" + (timedOut ? " (timeout)" : ""), 0);
            if (errorOccurredHere && test.getErrorProperty() != null) {
                this.project.setNewProperty(test.getErrorProperty(), "true");
            }
            if (failureOccurredHere && test.getFailureProperty() != null) {
                this.project.setNewProperty(test.getFailureProperty(), "true");
            }
        }
    }
}

