/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.graph;

import org.quilt.graph.Connector;
import org.quilt.graph.Edge;
import org.quilt.graph.Vertex;

public class BinaryConnector
extends Connector {
    private Edge edge;
    private Edge otherEdge;
    private Vertex source = null;

    private void doSetUp(Edge e, Edge otherE) {
        if (e == null || otherE == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        this.edge = e;
        this.source = this.edge.getSource();
        this.otherEdge = otherE;
        if (this.source != this.otherEdge.getSource()) {
            throw new IllegalArgumentException("edges in a BinaryConnector must have the same source");
        }
    }

    public BinaryConnector(Edge e, Edge otherE) {
        this.doSetUp(e, otherE);
    }

    public BinaryConnector(Connector conn, Edge otherE) {
        if (conn == null) {
            throw new IllegalArgumentException("connector cannot be null");
        }
        this.doSetUp(conn.getEdge(), otherE);
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Vertex getTarget() {
        return this.edge.getTarget();
    }

    public void setTarget(Vertex v) {
        this.checkTarget(v);
        this.edge.setTarget(v);
    }

    public int size() {
        return 2;
    }

    private void checkTarget(Vertex target) {
        if (target == null) {
            throw new IllegalArgumentException("target may not be null");
        }
        if (this.source == null) {
            System.out.println("BinaryConnector.checkTarget INTERNAL ERROR:  source is null");
        } else if (this.source.getGraph() == null) {
            System.out.println("BinaryConnector.checkTarget: source has no graph!");
        }
        if (target.getGraph() == null) {
            System.out.println("BinaryConnector.checkTarget: target has no graph!");
        }
        if (target.getGraph() != this.source.getGraph()) {
            throw new IllegalArgumentException("new target must be in same graph");
        }
    }

    public Edge getOtherEdge() {
        return this.otherEdge;
    }

    public Vertex getOtherTarget() {
        return this.otherEdge.getTarget();
    }

    public void setOtherTarget(Vertex v) {
        this.checkTarget(v);
        this.otherEdge.setTarget(v);
    }
}

