/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.graph;

import org.quilt.graph.Connector;
import org.quilt.graph.Edge;
import org.quilt.graph.Vertex;

public class ComplexConnector
extends Connector {
    private Edge edge;
    private Edge[] edges = null;
    private Vertex source = null;

    public ComplexConnector(Edge e, int n) {
        if (e == null || n < 1) {
            throw new IllegalArgumentException("constructor arguments must be in range and not null");
        }
        this.edge = new Edge(e);
        this.edges = new Edge[n];
        this.source = this.edge.getSource();
        Vertex target = this.edge.getTarget();
        int i = 0;
        while (i < n) {
            this.edges[i] = new Edge(this.source, target);
            ++i;
        }
    }

    public ComplexConnector(Connector conn, int n) {
        this(conn.getEdge(), n);
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Vertex getTarget() {
        return this.edge.getTarget();
    }

    public void setTarget(Vertex v) {
        this.checkTarget(v);
        this.edge.setTarget(v);
    }

    private void checkTarget(Vertex target) {
        if (target == null) {
            throw new IllegalArgumentException("target may not be null");
        }
        if (this.source.getGraph() != target.getGraph()) {
            throw new IllegalArgumentException("ComplexConnector's target must be in the same graph");
        }
    }

    private void rangeCheck(int n) {
        if (n < 0 || n >= this.edges.length) {
            throw new IllegalArgumentException("ComplexConnector index " + n + " out of range 0.." + (this.edges.length - 1));
        }
    }

    public Edge getEdge(int n) {
        this.rangeCheck(n);
        return this.edges[n];
    }

    public Vertex getTarget(int n) {
        this.rangeCheck(n);
        return this.edges[n].getTarget();
    }

    public void setTarget(Vertex v, int n) {
        this.checkTarget(v);
        this.rangeCheck(n);
        this.edges[n].setTarget(v);
    }

    public int size() {
        return this.edges.length;
    }
}

