/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.graph;

import org.quilt.graph.ComplexConnector;
import org.quilt.graph.Edge;
import org.quilt.graph.Entry;
import org.quilt.graph.Exit;
import org.quilt.graph.UnaryConnector;
import org.quilt.graph.Vertex;
import org.quilt.graph.Visitor;
import org.quilt.graph.Walker;

public class Directed {
    private Entry entry = null;
    private Exit exit = null;
    protected static int graphIndex = 0;
    private int index = 0;
    private Directed parent_ = null;
    private int depth = 0;
    private int vCount = 0;
    private int eCount = 0;

    public Directed() {
        graphIndex = 0;
        this.index = 0;
        this.entry = new Entry(this);
        this.exit = (Exit)this.entry.getTarget();
    }

    public Directed getParent() {
        return this.parent_;
    }

    public int getIndex() {
        return this.index;
    }

    protected Directed(Directed parent) {
        this.index = ++graphIndex;
        this.entry = new Entry(this);
        this.exit = (Exit)this.entry.getTarget();
        Directed.checkForNull(parent, "parent");
        this.depth = parent.getDepth() + 1;
        this.parent_ = parent;
    }

    protected static final Directed connectSubgraph(Directed subgraph, Edge e, int n) {
        Directed.checkForNull(e, "edge");
        if (n < 1) {
            throw new IllegalArgumentException("out of range argument");
        }
        Entry subEntry = subgraph.getEntry();
        subEntry.setConnector(new ComplexConnector(subEntry.getConnector(), n));
        Vertex target = e.getTarget();
        e.setTarget(subEntry);
        subgraph.getExit().getEdge().setTarget(target);
        return subgraph;
    }

    public Directed subgraph(Edge e, int n) {
        return Directed.connectSubgraph(new Directed(this), e, n);
    }

    public int getDepth() {
        return this.depth;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public Exit getExit() {
        return this.exit;
    }

    public static void checkForNull(Object o, String what) {
        if (o == null) {
            throw new IllegalArgumentException("null " + what);
        }
    }

    public int anotherEdge(Edge e) {
        return this.eCount++;
    }

    public int anotherVertex(Vertex v) {
        return this.vCount++;
    }

    protected final Vertex insertVertex(Vertex v, Edge e) {
        Directed.checkForNull(e, "edge");
        Vertex source = e.getSource();
        if (!(source instanceof Exit) && source.getGraph() != this) {
            System.out.println("Directed.insertVertex:\n    vertex:  " + v + "\n    edge:    " + e);
            throw new IllegalArgumentException("edge not in this graph");
        }
        Vertex target = e.getTarget();
        e.setTarget(v);
        v.setConnector(new UnaryConnector(new Edge(v, target)));
        return v;
    }

    public Vertex insertVertex(Edge e) {
        return this.insertVertex(new Vertex(this), e);
    }

    public int size() {
        Walker johnny = new Walker();
        Sizer counter = new Sizer();
        johnny.visit(this, counter);
        return counter.getVertexCount();
    }

    public Entry closestEntry(Directed g) {
        if (g == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (g == this) {
            return null;
        }
        Directed hisGraph = g;
        while (hisGraph != null) {
            if (hisGraph.getParent() == this) {
                return hisGraph.getEntry();
            }
            hisGraph = hisGraph.getParent();
        }
        return null;
    }

    private class Sizer
    implements Visitor {
        private int graphCount = 0;
        private int maxDepth = -1;
        private int vertexCount = 0;
        private int edgeCount = 0;

        public void discoverGraph(Directed g) {
            Directed.checkForNull(g, "graph");
            int depth = g.getDepth() + 1;
            ++this.graphCount;
            if (depth > this.maxDepth) {
                this.maxDepth = depth;
            }
        }

        public void finishGraph(Directed g) {
        }

        public void discoverVertex(Vertex v) {
            Directed.checkForNull(v, "vertex");
            ++this.vertexCount;
        }

        public void finishVertex(Vertex v) {
        }

        public void discoverEdge(Edge e) {
            Directed.checkForNull(e, "edge");
            ++this.edgeCount;
        }

        public void finishEdge(Edge e) {
        }

        public int getGraphCount() {
            return this.graphCount;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public int getEdgeCount() {
            return this.edgeCount;
        }
    }
}

