/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.graph;

import org.quilt.graph.Connector;
import org.quilt.graph.Directed;
import org.quilt.graph.Entry;
import org.quilt.graph.Exit;
import org.quilt.graph.Vertex;

public class Edge {
    protected Vertex source_;
    protected Vertex target_;

    public Edge(Vertex s, Vertex t) {
        if (s == null || t == null) {
            throw new IllegalArgumentException("null source or target");
        }
        if (s.getGraph() != t.getGraph() && !(s instanceof Exit) && !(t instanceof Entry)) {
            throw new IllegalArgumentException("source " + s + " and target " + t + " of edge constructor are not in the same graph");
        }
        this.source_ = s;
        this.target_ = t;
    }

    public Edge(Edge e) {
        Edge.checkForNull(e, "edge");
        this.source_ = e.getSource();
        this.target_ = e.getTarget();
    }

    public Vertex getSource() {
        return this.source_;
    }

    public void setSource(Vertex v) {
        Edge.checkForNull(v, "source");
        if (this.target_ != null && v.getGraph() != this.source_.getGraph()) {
            throw new IllegalArgumentException("source and target must be in same graph");
        }
        this.source_ = v;
    }

    public Vertex getTarget() {
        return this.target_;
    }

    public void setTarget(Vertex v) {
        Edge.checkForNull(v, "target");
        if (!(this.source_ instanceof Exit) && !(v instanceof Entry) && v.getGraph() != this.source_.getGraph()) {
            System.out.println("* WARNING * Edge {" + this.toString() + "}\n    being retargeted to vertex " + v);
        }
        this.target_ = v;
    }

    public static void checkForNull(Object o, String what) {
        if (o == null) {
            throw new IllegalArgumentException("null " + what);
        }
    }

    public Directed getGraph() {
        return this.source_.getGraph();
    }

    public void insert(Vertex v) {
        Edge.checkForNull(v, "vertex");
        if (this.source_.getGraph() != v.getGraph()) {
            throw new IllegalArgumentException("vertex is in another graph");
        }
        Connector vConn = v.getConnector();
        if (vConn == null) {
            throw new IllegalArgumentException("internal error: vertex has null connector");
        }
        Vertex oldTarget = this.target_;
        this.target_ = v;
        vConn.setTarget(oldTarget);
    }

    public String toString() {
        String s = this.source_.toString() + " ---> " + this.target_;
        return s;
    }
}

