/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.graph;

import org.quilt.graph.Connector;
import org.quilt.graph.Directed;
import org.quilt.graph.Edge;
import org.quilt.graph.Exit;
import org.quilt.graph.UnaryConnector;
import org.quilt.graph.Vertex;

public class Entry
extends Vertex {
    public Entry(Directed g) {
        if (g == null) {
            throw new IllegalArgumentException("null graph");
        }
        this.graph = g;
        this.index = g.anotherVertex(this);
        Edge edge = new Edge(this, this);
        this.connector = new UnaryConnector(edge);
        edge.insert(new Exit(g));
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Edge getEdge() {
        return this.connector.getEdge();
    }

    public Vertex getTarget() {
        return this.connector.getTarget();
    }

    public void setTarget(Vertex v) {
        Vertex.checkForNull(v, "target");
        if (v.getGraph() != this.graph) {
            throw new IllegalArgumentException("target must be in same graph");
        }
        ((UnaryConnector)this.connector).setTarget(v);
    }

    public String toString() {
        return "Entry " + super.toString();
    }
}

