/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.graph;

import org.quilt.graph.Connector;
import org.quilt.graph.Directed;
import org.quilt.graph.Edge;
import org.quilt.graph.UnaryConnector;
import org.quilt.graph.Vertex;

public class Exit
extends Vertex {
    protected Exit(Directed g) {
        Vertex.checkForNull(g, "graph");
        this.graph = g;
        this.index = g.anotherVertex(this);
        this.connector = new UnaryConnector(new Edge(this, this));
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Edge getEdge() {
        return ((UnaryConnector)this.connector).getEdge();
    }

    public Vertex getTarget() {
        return ((UnaryConnector)this.connector).getTarget();
    }

    public void setTarget(Vertex v) {
        Vertex.checkForNull(v, "target");
        if (this.graph == v.getGraph()) {
            throw new IllegalArgumentException("target of exit must be in different graph");
        }
        ((UnaryConnector)this.connector).setTarget(v);
    }

    public String toString() {
        return "Exit " + super.toString();
    }
}

