/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.graph;

import org.quilt.graph.Connector;
import org.quilt.graph.Edge;
import org.quilt.graph.Vertex;

public class MultiConnector
extends Connector {
    private Edge[] edges = null;
    private Vertex source = null;

    public MultiConnector(Edge seed, int n) {
        if (seed == null || n < 1) {
            throw new IllegalArgumentException("constructor arguments null or not in range");
        }
        Vertex source = seed.getSource();
        source = seed.getSource();
        Vertex target = seed.getTarget();
        this.edges = new Edge[n];
        this.edges[0] = new Edge(seed);
        int i = 1;
        while (i < n) {
            this.edges[i] = new Edge(source, target);
            ++i;
        }
    }

    public MultiConnector(Connector conn, int n) {
        this(conn.getEdge(), n);
    }

    public Edge getEdge() {
        return this.edges[0];
    }

    public Vertex getTarget() {
        return this.edges[0].getTarget();
    }

    public void setTarget(Vertex v) {
        this.checkTarget(v);
        this.edges[0].setTarget(v);
    }

    private void checkTarget(Vertex target) {
        if (target == null) {
            throw new IllegalArgumentException("target may not be null");
        }
        if (target.getGraph() != this.source.getGraph()) {
            throw new IllegalArgumentException("new target must be in same graph");
        }
    }

    private void rangeCheck(int n) {
        if (n < 0 || n >= this.edges.length) {
            throw new IllegalArgumentException("MultiConnector index out of range");
        }
    }

    public Edge getEdge(int n) {
        this.rangeCheck(n);
        return this.edges[n];
    }

    public Vertex getTarget(int n) {
        this.rangeCheck(n);
        return this.edges[n].getTarget();
    }

    public void setTarget(Vertex v, int n) {
        this.checkTarget(v);
        this.rangeCheck(n);
        this.edges[n].setTarget(v);
    }

    public int size() {
        return this.edges.length;
    }
}

