/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.graph;

import org.quilt.graph.BinaryConnector;
import org.quilt.graph.ComplexConnector;
import org.quilt.graph.Connector;
import org.quilt.graph.Directed;
import org.quilt.graph.Edge;
import org.quilt.graph.MultiConnector;

public class Vertex {
    protected int index = -1;
    protected Directed graph = null;
    protected Connector connector = null;
    protected String label_ = null;

    protected Vertex() {
    }

    public Vertex(Directed g) {
        Vertex.checkForNull(g, "graph");
        this.graph = g;
        this.index = g.anotherVertex(this);
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector c) {
        Vertex.checkForNull(c, "connector");
        this.connector = c;
    }

    public Edge getEdge() {
        if (this.connector == null) {
            return null;
        }
        return this.connector.getEdge();
    }

    public Vertex getTarget() {
        if (this.connector == null) {
            return null;
        }
        return this.connector.getTarget();
    }

    public Directed getGraph() {
        return this.graph;
    }

    public int getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String s) {
        this.label_ = s;
    }

    public Edge makeBinary() {
        Edge otherEdge = new Edge(this, this.graph.getExit());
        this.connector = new BinaryConnector(this.connector, otherEdge);
        return otherEdge;
    }

    public ComplexConnector makeComplex(int n) {
        this.connector = new ComplexConnector(this.connector, n);
        return (ComplexConnector)this.connector;
    }

    public MultiConnector makeMulti(int n) {
        this.connector = new MultiConnector(this.connector, n);
        return (MultiConnector)this.connector;
    }

    public boolean above(Directed g) {
        System.out.println("above: checking whether graph " + g.getIndex() + " is above vertex " + this.toString() + " whose parent is graph " + this.getGraph().getParent().getIndex());
        if (g == null || g == this.graph) {
            return false;
        }
        Directed pop = this.graph.getParent();
        while (pop != null) {
            System.out.println("  checking whether graph " + g.getIndex() + " is the same as graph " + pop.getIndex());
            if (pop == g) {
                return true;
            }
            pop = pop.getParent();
        }
        return false;
    }

    public static void checkForNull(Object o, String what) {
        if (o == null) {
            throw new IllegalArgumentException("null " + what);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append(this.graph.getIndex()).append(":").append(this.index);
        return sb.toString();
    }
}

