/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.graph;

import java.util.HashSet;
import org.quilt.graph.BinaryConnector;
import org.quilt.graph.ComplexConnector;
import org.quilt.graph.Connector;
import org.quilt.graph.Directed;
import org.quilt.graph.Edge;
import org.quilt.graph.Entry;
import org.quilt.graph.Exit;
import org.quilt.graph.MultiConnector;
import org.quilt.graph.UnaryConnector;
import org.quilt.graph.Vertex;
import org.quilt.graph.Visitor;

public class Walker {
    private Directed graph = null;
    private Entry entry = null;
    private Exit exit = null;
    private Visitor visitor = null;
    private HashSet vertices = new HashSet();
    private HashSet edges = new HashSet();

    public Exit visit(Directed g, Visitor guest) {
        Directed.checkForNull(g, "graph");
        Directed.checkForNull(guest, "Visitor");
        this.graph = g;
        this.entry = g.getEntry();
        this.exit = g.getExit();
        this.visitor = guest;
        this.visitor.discoverGraph(this.graph);
        this.visitVertex(this.graph.getEntry());
        this.visitor.finishGraph(this.graph);
        return this.exit;
    }

    private void visitVertex(Vertex v) {
        Directed.checkForNull(v, "vertex");
        if (this.vertices.contains(v)) {
            return;
        }
        this.vertices.add(v);
        if (v == this.exit) {
            this.visitor.discoverVertex(v);
            Edge e = v.getEdge();
            if (e.getTarget().getGraph() == this.graph) {
                this.visitEdge(v.getEdge());
            }
            this.visitor.finishVertex(v);
        } else if (v != this.entry && v instanceof Entry) {
            Walker subWalker = new Walker();
            Exit subExit = subWalker.visit(v.getGraph(), this.visitor);
            this.visitVertex(((UnaryConnector)subExit.getConnector()).getEdge().getTarget());
        } else {
            this.visitor.discoverVertex(v);
            Connector conn = v.getConnector();
            this.visitEdge(conn.getEdge());
            if (conn instanceof BinaryConnector) {
                this.visitEdge(((BinaryConnector)conn).getOtherEdge());
            } else if (conn instanceof ComplexConnector) {
                int size = conn.size();
                int i = 0;
                while (i < size) {
                    this.visitEdge(((ComplexConnector)conn).getEdge(i));
                    ++i;
                }
            } else if (!(conn instanceof UnaryConnector)) {
                if (conn instanceof MultiConnector) {
                    int i = 1;
                    while (i < conn.size()) {
                        this.visitEdge(((MultiConnector)conn).getEdge(i));
                        ++i;
                    }
                } else {
                    System.out.println("Walker.visitVertex: INTERNAL ERROR\n    don't know how to handle this kind of connection");
                }
            }
            this.visitor.finishVertex(v);
        }
    }

    private void visitEdge(Edge e) {
        Directed.checkForNull(e, "edge");
        if (this.edges.contains(e)) {
            return;
        }
        this.edges.add(e);
        this.visitor.discoverEdge(e);
        Vertex target = e.getTarget();
        Directed.checkForNull(target, "edge target");
        if (target instanceof Entry) {
            Directed targetGraph;
            Vertex source = e.getSource();
            Directed sourceGraph = source.getGraph();
            if (sourceGraph != (targetGraph = e.getTarget().getGraph()) && targetGraph != sourceGraph.getParent()) {
                this.visitVertex(target);
            }
        } else if (target instanceof Exit) {
            Directed targetGraph;
            Directed sourceGraph = e.getSource().getGraph();
            if (sourceGraph == (targetGraph = e.getTarget().getGraph())) {
                this.visitVertex(target);
            }
        } else {
            this.visitVertex(target);
        }
        this.visitor.finishEdge(e);
    }
}

