/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.reg;

import java.util.Comparator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Registry {
    private SortedMap registry = new TreeMap(new CmpArrays());

    public Registry() {
        this.registry.clear();
    }

    public final void clear() {
        this.registry.clear();
    }

    final Comparator comparator() {
        return new CmpArrays();
    }

    public final boolean containsKey(String[] key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        return this.registry.containsKey(key);
    }

    public final Object get(String[] key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (this.registry.containsKey(key)) {
            return this.registry.get(key);
        }
        return null;
    }

    public final boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public Set keySet() {
        return this.registry.keySet();
    }

    public final Object put(String[] key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        String[] keyCopy = new String[key.length];
        int i = 0;
        while (i < key.length) {
            keyCopy[i] = key[i];
            ++i;
        }
        return this.registry.put(keyCopy, value);
    }

    public final Object remove(String[] key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        return this.registry.remove(key);
    }

    public final int size() {
        return this.registry.size();
    }

    public final String[] splitClassName(String name) {
        return name.split(".");
    }

    private class CmpArrays
    implements Comparator {
        private CmpArrays() {
        }

        public int compare(Object o1, Object o2) {
            String[] str1 = (String[])o1;
            int depth1 = str1.length;
            String[] str2 = (String[])o2;
            int depth2 = str2.length;
            int depth = depth1 < depth2 ? depth1 : depth2;
            int i = 0;
            while (i < depth) {
                int rel = str1[i].compareTo(str2[i]);
                if (rel < 0) {
                    return -1;
                }
                if (rel > 0) {
                    return 1;
                }
                ++i;
            }
            if (depth1 < depth2) {
                return -1;
            }
            if (depth1 > depth2) {
                return 1;
            }
            return 0;
        }
    }
}

