/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.reports;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.quilt.framework.QuiltTest;
import org.quilt.reports.BaseFormatter;
import org.quilt.runner.Runner;

public class BriefFormatter
extends BaseFormatter {
    public BriefFormatter() {
        this.results = new StringWriter();
        this.resultWriter = new PrintWriter(this.results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTestSuite(QuiltTest suite) throws BuildException {
        StringBuffer sb = new StringBuffer("Testsuite: " + suite.getName() + "\nTests run: " + suite.runCount() + ", Failures: " + suite.failureCount() + ", Errors: " + suite.errorCount() + ", Time elapsed: " + this.numberFormat.format((double)suite.getRunTime() / 1000.0) + " sec\n\n");
        if (this.systemOutput != null && this.systemOutput.length() > 0) {
            sb.append("------------- Standard Output ----------------\n" + this.systemOutput + "------------- ---------------- ---------------\n");
        }
        if (this.systemError != null && this.systemError.length() > 0) {
            sb.append("------------- Standard Error -----------------\n" + this.systemError + "------------- ---------------- ---------------\n");
        }
        if (this.output != null) {
            try {
                this.output.write(sb.toString());
                this.resultWriter.close();
                this.output.write(this.results.toString());
                this.output.flush();
            }
            finally {
                if (this.out != System.out && this.out != System.err) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("\tFAILED", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable error) {
        this.formatError("\tCaused an ERROR", test, error);
    }

    private synchronized void formatError(String msg, Test test, Throwable error) {
        if (test == null) {
            this.resultWriter.println("Null test: " + msg);
        } else {
            this.endTest(test);
            this.resultWriter.println("Testcase: " + test + ": " + msg);
        }
        this.resultWriter.println(error.getMessage());
        String strace = Runner.getFilteredTrace(error, this.filtertrace);
        this.resultWriter.println(strace);
        this.resultWriter.println();
    }
}

