/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.quilt.reports.Formatter;

public class FmtSelector {
    private String classname;
    private String extension = ".txt";
    private OutputStream out = System.out;
    private File outFile;
    private boolean useFile = true;
    private static Hashtable extensions = null;
    private static Hashtable types = null;

    public FmtSelector() {
        types = new Hashtable();
        types.put("brief", "org.quilt.reports.BriefFormatter");
        types.put("plain", "org.quilt.reports.PlainFormatter");
        types.put("summary", "org.quilt.reports.SummaryFormatter");
        types.put("xml", "org.quilt.reports.XMLFormatter");
        extensions = new Hashtable();
        extensions.put("org.quilt.reports.BriefFormatter", ".txt");
        extensions.put("org.quilt.reports.PlainFormatter", ".txt");
        extensions.put("org.quilt.reports.SummaryFormatter", ".txt");
        extensions.put("org.quilt.reports.XMLFormatter", ".xml");
    }

    public Formatter createFormatter() throws BuildException {
        if (this.classname == null) {
            throw new BuildException("missing formatter class name");
        }
        Class<?> fmtClass = null;
        try {
            fmtClass = Class.forName(this.classname);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        Formatter fmt = null;
        try {
            fmt = (Formatter)fmtClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ClassCastException e) {
            throw new BuildException(this.classname + " is not a Formatter");
        }
        if (this.useFile && this.outFile != null) {
            try {
                this.out = new FileOutputStream(this.outFile);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        fmt.setOutput(this.out);
        return fmt;
    }

    public boolean isKnownType(String t) {
        return types.containsKey(t);
    }

    public void setType(String t) {
        if (!types.containsKey(t)) {
            throw new BuildException("unknown formatter type " + t);
        }
        this.classname = (String)types.get(t);
        this.extension = (String)extensions.get(this.classname);
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String ext) {
        this.extension = ext;
    }

    public void setOutfile(File out) {
        this.outFile = out;
    }

    public void setOutput(OutputStream out) {
    }

    public boolean getUseFile() {
        return this.useFile;
    }

    public void setUseFile(boolean b) {
        this.useFile = b;
    }

    public String toString() {
        return "Formatter: " + this.classname + ", extension: " + this.extension;
    }
}

