/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.reports;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.quilt.framework.QuiltTest;
import org.quilt.reports.BaseFormatter;
import org.quilt.runner.Runner;

public class PlainFormatter
extends BaseFormatter {
    private Hashtable testStarts = new Hashtable();
    private Hashtable failed = new Hashtable();

    public PlainFormatter() {
        this.results = new StringWriter();
        this.resultWriter = new PrintWriter(this.results);
    }

    public void endTestSuite(QuiltTest qt) throws BuildException {
        StringBuffer sb = new StringBuffer("Testsuite: " + qt.getName() + "\nTests run: " + qt.runCount() + ", Failures: " + qt.failureCount() + ", Errors: " + qt.errorCount() + ", Time elapsed: " + this.numberFormat.format((double)qt.getRunTime() / 1000.0) + " sec\n");
        if (this.systemOutput != null && this.systemOutput.length() > 0) {
            sb.append("------------- Standard Output ----------------\n" + this.systemOutput + "------------- ---------------- ---------------\n");
        }
        if (this.systemError != null && this.systemError.length() > 0) {
            sb.append("------------- Standard Error -----------------\n" + this.systemError + "------------- ---------------- ---------------\n");
        }
        sb.append("\n");
        if (this.out != null) {
            try {
                this.out.write(sb.toString().getBytes());
                this.resultWriter.close();
                this.out.write(this.results.toString().getBytes());
                this.out.flush();
            }
            catch (IOException ioex) {
                throw new BuildException("Unable to write output", (Throwable)ioex);
            }
            finally {
                if (this.out != System.out && this.out != System.err) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public void startTest(Test t) {
        this.testStarts.put(t, new Long(System.currentTimeMillis()));
        this.failed.put(t, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTest(Test test) {
        PrintWriter printWriter = this.resultWriter;
        synchronized (printWriter) {
            this.resultWriter.print("Testcase: " + BaseFormatter.getTestName(test));
            if (Boolean.TRUE.equals(this.failed.get(test))) {
                return;
            }
            Long t0 = (Long)this.testStarts.get(test);
            double seconds = 0.0;
            if (t0 != null) {
                seconds = (double)(System.currentTimeMillis() - t0) / 1000.0;
            }
            this.resultWriter.println(" took " + this.numberFormat.format(seconds) + " sec");
        }
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("\tFAILED", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        this.formatError("\tCaused an ERROR", test, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatError(String type, Test test, Throwable t) {
        PrintWriter printWriter = this.resultWriter;
        synchronized (printWriter) {
            if (test != null) {
                this.endTest(test);
                this.failed.put(test, Boolean.TRUE);
            }
            this.resultWriter.println(type);
            this.resultWriter.println(t.getMessage());
            String strace = Runner.getFilteredTrace(t, this.filtertrace);
            this.resultWriter.print(strace);
            this.resultWriter.println("");
        }
    }
}

