/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.reports;

import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.quilt.framework.QuiltTest;
import org.quilt.reports.Formatter;
import org.quilt.runner.Runner;

public class SummaryFormatter
implements Formatter {
    private boolean filtertrace = false;
    private Runner runner = null;
    private NumberFormat nf = NumberFormat.getInstance();
    private OutputStream out;
    private boolean withOutAndErr = false;
    private String systemOutput = null;
    private String systemError = null;

    public void endTestSuite(QuiltTest qt) throws BuildException {
        StringBuffer sb = new StringBuffer("Tests run: " + qt.runCount() + ", Failures: " + qt.failureCount() + ", Errors: " + qt.errorCount() + ", Time elapsed: " + this.nf.format((double)qt.getRunTime() / 1000.0) + " sec\n");
        if (this.withOutAndErr) {
            if (this.systemOutput != null && this.systemOutput.length() > 0) {
                sb.append("Output:\n" + this.systemOutput + "\n");
            }
            if (this.systemError != null && this.systemError.length() > 0) {
                sb.append("Error:\n " + this.systemError + "\n");
            }
        }
        try {
            this.out.write(sb.toString().getBytes());
            this.out.flush();
        }
        catch (IOException e) {
            throw new BuildException("Unable to write summary output", (Throwable)e);
        }
        finally {
            if (this.out != System.out && this.out != System.err) {
                try {
                    this.out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setFiltertrace(boolean b) {
        this.filtertrace = b;
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setRunner(Runner testrunner) {
        this.runner = testrunner;
    }

    public void setSystemError(String err) {
        this.systemError = err;
    }

    public void setSystemOutput(String out) {
        this.systemOutput = out;
    }

    public void startTestSuite(QuiltTest suite) {
    }

    public void addError(Test test, Throwable t) {
    }

    public void addFailure(Test test, Throwable t) {
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void endTest(Test test) {
    }

    public void startTest(Test t) {
    }

    public void setWithOutAndErr(boolean value) {
        this.withOutAndErr = value;
    }
}

