/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.reports;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.DOMElementWriter;
import org.quilt.framework.QuiltTest;
import org.quilt.reports.Formatter;
import org.quilt.runner.Runner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLFormatter
implements Formatter {
    private boolean filtertrace = false;
    private static DocumentBuilderFactory dbf = null;
    private Document doc;
    private OutputStream out;
    private Element rootNode;
    private Runner runner = null;
    private Hashtable testNodes = new Hashtable();
    private Hashtable testStarts = new Hashtable();

    protected static String getTestName(Test test) {
        if (test instanceof TestSuite) {
            return ((TestSuite)test).getName();
        }
        if (test instanceof TestCase) {
            return ((TestCase)test).getName();
        }
        return "unknown";
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
            }
            return dbf.newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public void endTestSuite(QuiltTest qt) throws BuildException {
        this.rootNode.setAttribute("tests", "" + qt.runCount());
        this.rootNode.setAttribute("errors", "" + qt.errorCount());
        this.rootNode.setAttribute("failures", "" + qt.failureCount());
        this.rootNode.setAttribute("time", "" + (double)qt.getRunTime() / 1000.0);
        if (this.out != null) {
            OutputStreamWriter wri = null;
            try {
                wri = new OutputStreamWriter(this.out, "UTF8");
                wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
                new DOMElementWriter().write(this.rootNode, (Writer)wri, 0, "  ");
                ((Writer)wri).flush();
            }
            catch (IOException e) {
                throw new BuildException("Unable to write log file", (Throwable)e);
            }
            finally {
                if (this.out != System.out && this.out != System.err && wri != null) {
                    try {
                        ((Writer)wri).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public void setFiltertrace(boolean b) {
        this.filtertrace = b;
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setRunner(Runner testrunner) {
        this.runner = testrunner;
    }

    public void setSystemError(String out) {
        this.formatOutput("system-err", out);
    }

    public void setSystemOutput(String out) {
        this.formatOutput("system-out", out);
    }

    public void startTestSuite(QuiltTest qt) {
        this.doc = XMLFormatter.getDocumentBuilder().newDocument();
        this.rootNode = this.doc.createElement("testsuite");
        this.rootNode.setAttribute("name", qt.getName());
        Element propsElement = this.doc.createElement("properties");
        this.rootNode.appendChild(propsElement);
        Properties props = qt.getProperties();
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Element propElement = this.doc.createElement("property");
                propElement.setAttribute("name", name);
                propElement.setAttribute("value", props.getProperty(name));
                propsElement.appendChild(propElement);
            }
        }
    }

    public void addError(Test test, Throwable t) {
        this.formatError("error", test, t);
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("failure", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void endTest(Test test) {
        Element testNode = (Element)this.testNodes.get(test);
        if (testNode == null) {
            this.startTest(test);
            testNode = (Element)this.testNodes.get(test);
        }
        Long l = (Long)this.testStarts.get(test);
        testNode.setAttribute("time", "" + (double)(System.currentTimeMillis() - l) / 1000.0);
    }

    public void startTest(Test test) {
        this.testStarts.put(test, new Long(System.currentTimeMillis()));
        Element testNode = this.doc.createElement("testcase");
        testNode.setAttribute("name", XMLFormatter.getTestName(test));
        this.rootNode.appendChild(testNode);
        this.testNodes.put(test, testNode);
    }

    private void formatError(String type, Test test, Throwable t) {
        if (test != null) {
            this.endTest(test);
        }
        Element msgNode = this.doc.createElement(type);
        Element curNode = null;
        curNode = test != null ? (Element)this.testNodes.get(test) : this.rootNode;
        curNode.appendChild(msgNode);
        String message = t.getMessage();
        if (message != null && message.length() > 0) {
            msgNode.setAttribute("message", t.getMessage());
        }
        msgNode.setAttribute("type", t.getClass().getName());
        String strace = Runner.getFilteredTrace(t, this.filtertrace);
        Text trace = this.doc.createTextNode(strace);
        msgNode.appendChild(trace);
    }

    private void formatOutput(String type, String output) {
        Element txtNode = this.doc.createElement(type);
        this.rootNode.appendChild(txtNode);
        txtNode.appendChild(this.doc.createCDATASection(output));
    }
}

