/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.runner;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.AntClassLoader;
import org.quilt.cl.QuiltClassLoader;
import org.quilt.framework.QuiltTest;
import org.quilt.reports.Formatter;
import org.quilt.runner.Runner;

public class BaseTestRunner
extends Runner {
    private QuiltTest qt;
    private Test suite;
    private Exception exception;
    private int retCode;
    private TestResult res;
    private Vector formatters;
    private PrintStream systemError;
    private PrintStream systemOut;

    public BaseTestRunner(QuiltTest test) {
        this(test, null);
    }

    public BaseTestRunner(QuiltTest test, ClassLoader loader) {
        block8: {
            this.suite = null;
            this.exception = null;
            this.retCode = 0;
            this.formatters = new Vector();
            this.qt = test;
            try {
                Class<?> testClass = null;
                if (loader == null) {
                    testClass = Class.forName(this.qt.getName());
                } else {
                    testClass = loader.loadClass(this.qt.getName());
                    if (!(loader instanceof QuiltClassLoader)) {
                        AntClassLoader.initializeClass(testClass);
                    }
                }
                Method suiteMethod = null;
                try {
                    suiteMethod = testClass.getMethod("suite", new Class[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (suiteMethod != null) {
                    this.suite = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
                    break block8;
                }
                this.suite = new TestSuite(testClass);
            }
            catch (Exception e) {
                this.retCode = 2;
                this.exception = e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.res = new TestResult();
        this.res.addListener((TestListener)this);
        int i = 0;
        while (i < this.formatters.size()) {
            this.res.addListener((TestListener)this.formatters.elementAt(i));
            ++i;
        }
        long start = System.currentTimeMillis();
        this.fireStartTestSuite();
        if (this.exception != null) {
            int i2 = 0;
            while (i2 < this.formatters.size()) {
                ((TestListener)this.formatters.elementAt(i2)).addError(null, (Throwable)this.exception);
                ++i2;
            }
            this.qt.setCounts(1L, 0L, 1L);
            this.qt.setRunTime(0L);
        } else {
            ByteArrayOutputStream errStrm = new ByteArrayOutputStream();
            this.systemError = new PrintStream(errStrm);
            ByteArrayOutputStream outStrm = new ByteArrayOutputStream();
            this.systemOut = new PrintStream(outStrm);
            PrintStream savedOut = null;
            PrintStream savedErr = null;
            if (this.qt.getFork()) {
                savedOut = System.out;
                savedErr = System.err;
                if (!this.qt.getShowOutput()) {
                    System.setOut(this.systemOut);
                    System.setErr(this.systemError);
                } else {
                    System.setOut(new PrintStream(new TeeOutputStream(new OutputStream[]{savedOut, this.systemOut})));
                    System.setErr(new PrintStream(new TeeOutputStream(new OutputStream[]{savedErr, this.systemError})));
                }
            }
            try {
                this.suite.run(this.res);
            }
            finally {
                if (savedOut != null) {
                    System.setOut(savedOut);
                }
                if (savedErr != null) {
                    System.setErr(savedErr);
                }
                this.systemError.close();
                this.systemError = null;
                this.systemOut.close();
                this.systemOut = null;
                this.sendOutAndErr(new String(outStrm.toByteArray()), new String(errStrm.toByteArray()));
                this.qt.setCounts(this.res.runCount(), this.res.failureCount(), this.res.errorCount());
                this.qt.setRunTime(System.currentTimeMillis() - start);
            }
        }
        this.fireEndTestSuite();
        if (this.retCode != 0 || this.res.errorCount() != 0) {
            this.retCode = 2;
        } else if (this.res.failureCount() != 0) {
            this.retCode = 1;
        }
    }

    public int getRetCode() {
        return this.retCode;
    }

    public void startTest(Test t) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
        if (this.qt.getHaltOnFailure()) {
            this.res.stop();
        }
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        if (this.qt.getHaltOnError()) {
            this.res.stop();
        }
    }

    public void handleOutput(String line) {
        if (this.systemOut != null) {
            this.systemOut.println(line);
        }
    }

    public void handleErrorOutput(String line) {
        if (this.systemError != null) {
            this.systemError.println(line);
        }
    }

    public void handleFlush(String line) {
        if (this.systemOut != null) {
            this.systemOut.print(line);
        }
    }

    public void handleErrorFlush(String line) {
        if (this.systemError != null) {
            this.systemError.print(line);
        }
    }

    private void sendOutAndErr(String out, String err) {
        int i = 0;
        while (i < this.formatters.size()) {
            Formatter formatter = (Formatter)this.formatters.elementAt(i);
            formatter.setSystemOutput(out);
            formatter.setSystemError(err);
            ++i;
        }
    }

    private void fireStartTestSuite() {
        int i = 0;
        while (i < this.formatters.size()) {
            ((Formatter)this.formatters.elementAt(i)).startTestSuite(this.qt);
            ((Formatter)this.formatters.elementAt(i)).setFiltertrace(this.qt.getFiltertrace());
            ++i;
        }
    }

    private void fireEndTestSuite() {
        int i = 0;
        while (i < this.formatters.size()) {
            ((Formatter)this.formatters.elementAt(i)).endTestSuite(this.qt);
            ++i;
        }
    }

    public void addFormatter(Formatter f) {
        this.formatters.addElement(f);
    }

    private class TeeOutputStream
    extends OutputStream {
        private OutputStream[] outs;

        private TeeOutputStream(OutputStream[] outs) {
            this.outs = outs;
        }

        public void write(int b) throws IOException {
            int i = 0;
            while (i < this.outs.length) {
                this.outs[i].write(b);
                ++i;
            }
        }
    }
}

