/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.runner;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.apache.tools.ant.util.StringUtils;
import org.quilt.framework.QuiltTest;
import org.quilt.reports.Formatter;
import org.quilt.runner.RunnerConst;

public abstract class Runner
extends QuiltTest
implements RunnerConst,
TestListener {
    public abstract void run();

    public abstract int getRetCode();

    public static String getFilteredTrace(Throwable t, boolean filtertrace) {
        String trace = StringUtils.getStackTrace((Throwable)t);
        return Runner.filterStack(trace, filtertrace);
    }

    /*
     * WARNING - void declaration
     */
    public static String filterStack(String stack, boolean filtertrace) {
        if (!filtertrace) {
            return stack;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                void var6_6;
                if (Runner.filterLine((String)var6_6)) continue;
                pw.println((String)var6_6);
            }
        }
        catch (Exception IOException2) {
            return stack;
        }
        return sw.toString();
    }

    private static boolean filterLine(String line) {
        int i = 0;
        while (i < RunnerConst.DEFAULT_TRACE_FILTERS.length) {
            if (line.indexOf(RunnerConst.DEFAULT_TRACE_FILTERS[i]) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract void addFormatter(Formatter var1);

    public abstract void addFailure(Test var1, Throwable var2);

    public abstract void addFailure(Test var1, AssertionFailedError var2);

    public abstract void addError(Test var1, Throwable var2);

    public abstract void startTest(Test var1);

    public abstract void endTest(Test var1);

    public abstract void handleOutput(String var1);

    public abstract void handleErrorOutput(String var1);

    public abstract void handleFlush(String var1);

    public abstract void handleErrorFlush(String var1);
}

