/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.textui;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.quilt.cl.QuiltClassLoader;
import org.quilt.cover.stmt.StmtRegistry;
import org.quilt.framework.QuiltTest;
import org.quilt.reports.FmtSelector;
import org.quilt.runner.RunnerConst;

public abstract class Textui
implements RunnerConst {
    protected QuiltClassLoader quiltLoader = null;
    protected StmtRegistry stmtReg = null;

    public void usage() {
        System.out.println("usage:\njava [javaOptions] testName [testOptions]\nwhere the test options (all optional) are\n    checkCoverage={true|false}\n    checkIncludes={comma-separated list of class names}\n    checkExcludes={comma-separated list of class names}\n    haltOnError={true|false}\n    haltOnFailure={true|false}\n    filtertrace={true|false}\n    formatter={className[,outputName]}\n    propsfile={pathname}\n    showOutput={true|false}\nParameter values are not quoted.  Anything in square brackets []\nis optional.  Anything in curly braces {} is required.\n\n");
        System.exit(2);
    }

    protected int handleArgs(String[] args) {
        int retCode = 2;
        try {
            Vector<FmtSelector> myFormatters = new Vector<FmtSelector>();
            if (args.length == 0) {
                this.usage();
            }
            QuiltTest qt = new QuiltTest(args[0]);
            qt.setFork(true);
            Properties p = new Properties();
            int i = 1;
            while (i < args.length) {
                if (args[i].startsWith("checkCoverage=")) {
                    qt.setCheckCoverage(Project.toBoolean((String)args[i].substring(14)));
                } else if (args[i].startsWith("checkExcludes=")) {
                    qt.setCheckExcludes(args[i].substring(14));
                } else if (args[i].startsWith("checkIncludes=")) {
                    qt.setCheckIncludes(args[i].substring(14));
                } else if (args[i].startsWith("haltOnError=")) {
                    qt.setHaltOnError(Project.toBoolean((String)args[i].substring(12)));
                } else if (args[i].startsWith("haltOnFailure=")) {
                    qt.setHaltOnFailure(Project.toBoolean((String)args[i].substring(14)));
                } else if (args[i].startsWith("filtertrace=")) {
                    qt.setFiltertrace(Project.toBoolean((String)args[i].substring(12)));
                } else if (args[i].startsWith("formatter=")) {
                    try {
                        String selector = args[i].substring(10);
                        int commaAt = selector.indexOf(44);
                        FmtSelector fs = new FmtSelector();
                        if (commaAt < 0) {
                            fs.setClassname(selector);
                        } else {
                            fs.setClassname(selector.substring(0, commaAt));
                            fs.setOutfile(new File(selector.substring(commaAt + 1)));
                        }
                        myFormatters.addElement(fs);
                    }
                    catch (BuildException be) {
                        System.err.println(be.getMessage());
                        System.exit(2);
                    }
                } else if (args[i].startsWith("propsfile=")) {
                    FileInputStream in = new FileInputStream(args[i].substring(10));
                    p.load(in);
                    in.close();
                } else if (args[i].startsWith("showoutput=")) {
                    qt.setShowOutput(Project.toBoolean((String)args[i].substring(11)));
                }
                ++i;
            }
            Properties sysP = System.getProperties();
            Enumeration e = ((Hashtable)sysP).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                p.put(key, (String)((Hashtable)sysP).get(key));
            }
            qt.setProperties(p);
            if (qt.getCheckCoverage() && qt.getCheckIncludes() != null) {
                String myClasspath = System.getProperty("java.class.path");
                this.quiltLoader = new QuiltClassLoader(QuiltClassLoader.cpToURLs(myClasspath), null, null, qt.getCheckIncludesArray(), qt.getCheckExcludesArray());
                this.stmtReg = (StmtRegistry)this.quiltLoader.addQuiltRegistry("org.quilt.cover.stmt.StmtRegistry");
            }
            retCode = this.runWithIt(qt, myFormatters);
        }
        catch (Exception e) {
            System.out.println("EXCEPTION " + e);
            e.printStackTrace();
            retCode = 2;
        }
        return retCode;
    }

    int runWithIt(QuiltTest qt, Vector myFormatters) {
        System.out.println("Textui.runWithIt: you should never see this message");
        return 2;
    }
}

