/*
 * Decompiled with CFR 0.152.
 */
package biz.futureware.mantisconnect;

import biz.futureware.mantisconnect.MantisConnect;
import biz.futureware.mantisconnect.MantisConnectBindingStub;
import biz.futureware.mantisconnect.MantisConnectPortType;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class MantisConnectLocator
extends Service
implements MantisConnect {
    private String MantisConnectPort_address = "https://localhost/mantisbt/api/soap/mantisconnect.php";
    private String MantisConnectPortWSDDServiceName = "MantisConnectPort";
    private HashSet ports = null;

    public MantisConnectLocator() {
    }

    public MantisConnectLocator(EngineConfiguration config) {
        super(config);
    }

    public MantisConnectLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getMantisConnectPortAddress() {
        return this.MantisConnectPort_address;
    }

    public String getMantisConnectPortWSDDServiceName() {
        return this.MantisConnectPortWSDDServiceName;
    }

    public void setMantisConnectPortWSDDServiceName(String name) {
        this.MantisConnectPortWSDDServiceName = name;
    }

    @Override
    public MantisConnectPortType getMantisConnectPort() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.MantisConnectPort_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getMantisConnectPort(endpoint);
    }

    @Override
    public MantisConnectPortType getMantisConnectPort(URL portAddress) throws ServiceException {
        try {
            MantisConnectBindingStub _stub = new MantisConnectBindingStub(portAddress, this);
            _stub.setPortName(this.getMantisConnectPortWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setMantisConnectPortEndpointAddress(String address) {
        this.MantisConnectPort_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (MantisConnectPortType.class.isAssignableFrom(serviceEndpointInterface)) {
                MantisConnectBindingStub _stub = new MantisConnectBindingStub(new URL(this.MantisConnectPort_address), this);
                _stub.setPortName(this.getMantisConnectPortWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("MantisConnectPort".equals(inputPortName)) {
            return this.getMantisConnectPort();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://futureware.biz/mantisconnect", "MantisConnect");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://futureware.biz/mantisconnect", "MantisConnectPort"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"MantisConnectPort".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setMantisConnectPortEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

