/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.caching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.json.JSONElement;
import kong.unirest.json.JSONObject;
import org.apache.logging.log4j.LogManager;

public class CacheManager {
    protected String applicationName;
    protected String cacheManagerUrl;
    private static final int HTTP_OK = 200;

    public CacheManager() {
    }

    public CacheManager(String applicationName, String cacheManagerUrl) {
        this.applicationName = applicationName;
        this.cacheManagerUrl = cacheManagerUrl;
    }

    public String buildKey(String ... keyValues) {
        StringBuilder key = new StringBuilder(this.applicationName);
        String[] stringArray = keyValues;
        int n = keyValues.length;
        int n2 = 0;
        while (n2 < n) {
            String keyValue = stringArray[n2];
            key.append("_").append(keyValue);
            ++n2;
        }
        return key.toString();
    }

    public Map<String, String> getCache(String key, int validity) {
        HashMap<String, String> result = null;
        LogManager.getLogger(CacheManager.class).info(String.format("Get Cache for : %s with %d hour(s) validity", key, validity));
        HttpResponse jsonResponse = Unirest.get((String)String.format("%s/cache/%s/%d", this.cacheManagerUrl, key, validity)).asJson();
        if (jsonResponse.getStatus() == 200) {
            LogManager.getLogger(CacheManager.class).info(String.format("Cache hit for : %s", key));
            result = new HashMap<String, String>();
            JSONObject cacheMap = ((JsonNode)jsonResponse.getBody()).getObject().getJSONObject("cacheMap");
            Iterator cacheKeys = cacheMap.keys();
            while (cacheKeys.hasNext()) {
                String cacheKey = (String)cacheKeys.next();
                result.put(cacheKey, cacheMap.getString(cacheKey));
                LogManager.getLogger(CacheManager.class).debug(String.format("Cache retrieved for : %s, [%s] = %s", key, cacheKey, cacheMap.getString(cacheKey)));
            }
        } else {
            LogManager.getLogger(CacheManager.class).info(String.format("Cache not found for : %s", key));
        }
        return result;
    }

    public boolean setCache(String key, Map<String, String> values) {
        LogManager.getLogger(CacheManager.class).info(String.format("Set Cache for : %s", key));
        JSONObject cacheEntry = new JSONObject();
        cacheEntry.put("cacheKey", key);
        JSONObject cacheValues = new JSONObject();
        values.entrySet().forEach(me -> {
            cacheValues.put((String)me.getKey(), (String)me.getValue());
            LogManager.getLogger(CacheManager.class).debug(String.format("Cache value for : %s, [%s] = %s", key, me.getKey(), me.getValue()));
        });
        cacheEntry.put("cacheMap", cacheValues);
        HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)String.format("%s/cache", this.cacheManagerUrl)).header("Content-Type", "application/json")).body((JSONElement)cacheEntry).asJson();
        LogManager.getLogger(CacheManager.class).info(String.format("Set Cache for : %s, response code : %d", key, response.getStatus()));
        return response.getStatus() == 200;
    }
}

