/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.datalake;

import com.michelin.cert.redscan.utils.datalake.DatalakeStorageException;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageItem;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageResponseCode;
import java.text.SimpleDateFormat;
import java.util.Date;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.RequestBodyEntity;
import kong.unirest.Unirest;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONElement;
import kong.unirest.json.JSONObject;
import org.apache.logging.log4j.LogManager;

public class DatalakeStorage {
    private static final int NB_RECORD = 1000;
    private static final String PIT_KEEP_ALIVE = "1m";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static String elasticSearchUrl;
    private static String elasticSearchUser;
    private static String elasticSearchPassword;

    private DatalakeStorage() {
    }

    public static void init(String elasticSearchUrl, String elasticSearchUser, String elasticSearchPassword) {
        Unirest.config().verifySsl(false);
        DatalakeStorage.elasticSearchUrl = elasticSearchUrl;
        DatalakeStorage.elasticSearchUser = elasticSearchUser;
        DatalakeStorage.elasticSearchPassword = elasticSearchPassword;
    }

    public static JSONObject getObjects(DatalakeStorageItem item, JSONObject query, JSONObject sort) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(item.getIndex(), query, sort);
    }

    public static JSONObject getObjects(DatalakeStorageItem item, JSONObject query) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(item.getIndex(), query, null);
    }

    public static JSONObject getObjects(String index, JSONObject query, JSONObject sort) throws DatalakeStorageException {
        JSONObject results = null;
        try {
            query = query != null ? query : new JSONObject("{\"query_string\" : {\"query\":\"*\"}}");
            sort = sort != null ? sort : new JSONObject("{\"_id\" :\"asc\"}");
            HttpResponse res = ((HttpRequestWithBody)Unirest.post((String)String.format("%s/%s/_pit?keep_alive=%s", elasticSearchUrl, index, PIT_KEEP_ALIVE)).basicAuth(elasticSearchUser, elasticSearchPassword)).asString();
            if (res.getStatus() == DatalakeStorageResponseCode.HTTP_OK) {
                JSONArray objects = new JSONArray();
                JSONArray searchAfterArray = null;
                JSONObject pit = new JSONObject((String)res.getBody());
                pit.put("keep_alive", PIT_KEEP_ALIVE);
                JSONObject jsonRequestObject = new JSONObject();
                jsonRequestObject.put("query", query);
                jsonRequestObject.put("size", 1000);
                jsonRequestObject.put("sort", sort);
                jsonRequestObject.put("pit", pit);
                boolean searchEnded = false;
                while (!searchEnded) {
                    if (searchAfterArray != null) {
                        jsonRequestObject.put("search_after", searchAfterArray);
                    }
                    if ((res = ((RequestBodyEntity)((HttpRequestWithBody)Unirest.post((String)String.format("%s/_search", elasticSearchUrl)).header("Content-Type", "application/json")).body((JSONElement)jsonRequestObject).basicAuth(elasticSearchUser, elasticSearchPassword)).asString()).getStatus() == DatalakeStorageResponseCode.HTTP_OK) {
                        JSONObject searchResult = new JSONObject((String)res.getBody());
                        JSONObject hitsObject = searchResult.getJSONObject("hits");
                        if (hitsObject != null) {
                            JSONArray currentHits = hitsObject.getJSONArray("hits");
                            if (currentHits != null && currentHits.length() > 0) {
                                int nbHits = 0;
                                while (nbHits < currentHits.length()) {
                                    objects.put(currentHits.getJSONObject(nbHits++));
                                }
                                if (nbHits == 0) continue;
                                searchAfterArray = currentHits.getJSONObject(nbHits - 1).getJSONArray("sort");
                                pit.put("id", searchResult.getString("pit_id"));
                                continue;
                            }
                            searchEnded = true;
                            continue;
                        }
                        searchEnded = true;
                        continue;
                    }
                    LogManager.getLogger(DatalakeStorageItem.class).error(String.format("GetObjects (%s) status : %d body : %s", index, res.getStatus(), res.getBody()));
                    searchEnded = true;
                }
                ((RequestBodyEntity)((HttpRequestWithBody)Unirest.delete((String)String.format("%s/_pit", elasticSearchUrl)).header("Content-Type", "application/json")).body((JSONElement)pit).basicAuth(elasticSearchUser, elasticSearchPassword)).asString();
                if (objects.length() > 0) {
                    JSONObject total = new JSONObject();
                    total.put("relation", "eq");
                    total.put("value", objects.length());
                    results = new JSONObject();
                    results.put("total", total);
                    results.put("hits", objects);
                }
            } else {
                LogManager.getLogger(DatalakeStorageItem.class).error(String.format("GetObjects (%s) create PIT failed : %d body : %s", index, res.getStatus(), res.getBody()));
            }
        }
        catch (Exception ex) {
            LogManager.getLogger(DatalakeStorageItem.class).error(String.format("GetObjects (Index : %s) (Query: %s) : %s", index, query, ex.getMessage()));
            throw new DatalakeStorageException(String.format("GetObjects (Index : %s) (Query: %s) : %s", index, query, ex.getMessage()), ex);
        }
        return results;
    }

    public static JSONObject getObjects(DatalakeStorageItem item, JSONObject query, String page, String size, JSONObject sort) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(item.getIndex(), query, page, size, sort);
    }

    public static JSONObject getObjects(DatalakeStorageItem item, JSONObject query, String page, String size) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(item.getIndex(), query, page, size, null);
    }

    public static JSONObject getObjects(String index, JSONObject query, String page, String size, JSONObject sort) throws DatalakeStorageException {
        JSONObject results = null;
        try {
            query = query != null ? query : new JSONObject("{\"query_string\" : {\"query\":\"*\"}}");
            sort = sort != null ? sort : new JSONObject("{\"_id\" :\"asc\"}");
            JSONArray objects = new JSONArray();
            JSONObject jsonRequestObject = new JSONObject();
            jsonRequestObject.put("query", query);
            jsonRequestObject.put("size", size == null ? 1000 : Integer.parseInt(size));
            jsonRequestObject.put("from", page == null ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(size));
            jsonRequestObject.put("sort", sort);
            HttpResponse res = ((RequestBodyEntity)((HttpRequestWithBody)Unirest.post((String)String.format("%s/%s/_search", elasticSearchUrl, index)).header("Content-Type", "application/json")).body((JSONElement)jsonRequestObject).basicAuth(elasticSearchUser, elasticSearchPassword)).asString();
            if (res.getStatus() == DatalakeStorageResponseCode.HTTP_OK) {
                JSONArray currentHits;
                JSONObject searchResult = new JSONObject((String)res.getBody());
                JSONObject hitsObject = searchResult.getJSONObject("hits");
                if (hitsObject != null && (currentHits = hitsObject.getJSONArray("hits")) != null && currentHits.length() > 0) {
                    int nbHits = 0;
                    while (nbHits < currentHits.length()) {
                        objects.put(currentHits.getJSONObject(nbHits++));
                    }
                }
            } else {
                LogManager.getLogger(DatalakeStorageItem.class).error(String.format("GetObjects (%s) status : %d body : %s", index, res.getStatus(), res.getBody()));
            }
            if (objects.length() > 0) {
                JSONObject total = new JSONObject();
                total.put("relation", "eq");
                total.put("value", objects.length());
                results = new JSONObject();
                results.put("total", total);
                results.put("hits", objects);
            }
        }
        catch (Exception ex) {
            LogManager.getLogger(DatalakeStorageItem.class).error(String.format("GetObjects (Index : %s) (Query: %s) : %s", index, query, ex.getMessage()));
            throw new DatalakeStorageException(String.format("GetObjects (Index : %s) (Query: %s) : %s", index, query, ex.getMessage()), ex);
        }
        return results;
    }

    public static JSONObject getObject(DatalakeStorageItem item) throws DatalakeStorageException {
        return DatalakeStorage.getObject(item, item.getId());
    }

    public static JSONObject getObject(DatalakeStorageItem item, String id) throws DatalakeStorageException {
        return DatalakeStorage.getObject(item.getIndex(), id);
    }

    public static JSONObject getObject(String index, String id) throws DatalakeStorageException {
        JSONObject result = null;
        try {
            HttpResponse res = ((GetRequest)Unirest.get((String)String.format("%s/%s/_doc/%s", elasticSearchUrl, index, id)).basicAuth(elasticSearchUser, elasticSearchPassword)).asString();
            if (res.getStatus() != DatalakeStorageResponseCode.HTTP_OK && res.getStatus() != DatalakeStorageResponseCode.HTTP_NOT_FOUND) {
                LogManager.getLogger(DatalakeStorageItem.class).info(String.format("GetObject (%s) from index %s status : %d body : %s", id, index, res.getStatus(), res.getBody()));
            }
            result = res.getStatus() == DatalakeStorageResponseCode.HTTP_OK ? new JSONObject((String)res.getBody()).getJSONObject("_source") : null;
        }
        catch (Exception ex) {
            LogManager.getLogger(DatalakeStorageItem.class).error(String.format("GetObject (%s) from index %s : %s", id, index, ex.getMessage()));
            throw new DatalakeStorageException(String.format("GetObject (%s) from index %s : %s", id, index, ex.getMessage()), ex);
        }
        return result;
    }

    public static boolean createObject(DatalakeStorageItem item) throws DatalakeStorageException {
        boolean result = false;
        if (item.findContent(null) == null) {
            JSONObject jsonId = new JSONObject();
            jsonId.put("id", item.getId());
            if (item.getParent() != null) {
                jsonId.put("parent", item.getParent());
            }
            jsonId.put("@timestamp", DatalakeStorage.generateDate());
            result = DatalakeStorage.createObject(item.getIndex(), item.getId(), jsonId);
        }
        return result;
    }

    public static boolean createObject(String index, String id) throws DatalakeStorageException {
        JSONObject jsonId = new JSONObject();
        jsonId.put("id", id);
        jsonId.put("@timestamp", DatalakeStorage.generateDate());
        return DatalakeStorage.createObject(index, id, jsonId);
    }

    public static boolean createObject(String index, String id, JSONObject jsonObject) throws DatalakeStorageException {
        boolean result = false;
        try {
            HttpResponse res = ((RequestBodyEntity)((HttpRequestWithBody)Unirest.post((String)String.format("%s/%s/_create/%s", elasticSearchUrl, index, id)).header("Content-Type", "application/json")).body((JSONElement)jsonObject).basicAuth(elasticSearchUser, elasticSearchPassword)).asEmpty();
            if (res.getStatus() != DatalakeStorageResponseCode.HTTP_CREATED) {
                LogManager.getLogger(DatalakeStorageItem.class).info(String.format("CreateObject (%s) from index %s status : %d body : %s", id, index, res.getStatus(), res.getBody()));
            }
            result = res.getStatus() == DatalakeStorageResponseCode.HTTP_CREATED;
        }
        catch (Exception ex) {
            LogManager.getLogger(DatalakeStorageItem.class).error(String.format("CreateObject (%s) from index %s : %s", id, index, ex.getMessage()));
            throw new DatalakeStorageException(String.format("CreateObject (%s) from index %s : %s", id, index, ex.getMessage()), ex);
        }
        return result;
    }

    public static boolean deleteObject(DatalakeStorageItem item) throws DatalakeStorageException {
        return DatalakeStorage.deleteObject(item.getIndex(), item.getId());
    }

    public static boolean deleteObject(String index, String id) throws DatalakeStorageException {
        boolean result = false;
        try {
            HttpResponse res = ((HttpRequestWithBody)Unirest.delete((String)String.format("%s/%s/_doc/%s", elasticSearchUrl, index, id)).basicAuth(elasticSearchUser, elasticSearchPassword)).asEmpty();
            if (res.getStatus() != DatalakeStorageResponseCode.HTTP_OK) {
                LogManager.getLogger(DatalakeStorageItem.class).info(String.format("DeleteObject (%s) from index %s status : %d body : %s", id, index, res.getStatus(), res.getBody()));
            }
            result = res.getStatus() == DatalakeStorageResponseCode.HTTP_OK;
        }
        catch (Exception ex) {
            LogManager.getLogger(DatalakeStorageItem.class).error(String.format("DeleteObject (%s) from index %s : %s", id, index, ex.getMessage()));
            throw new DatalakeStorageException(String.format("DeleteObject (%s) from index %s : %s", id, index, ex.getMessage()), ex);
        }
        return result;
    }

    public static boolean upsertObjectField(DatalakeStorageItem item, String key, Object value) throws DatalakeStorageException {
        return DatalakeStorage.upsertObjectField(item.getIndex(), item.getId(), key, value);
    }

    public static boolean upsertObjectField(String index, String id, String key, Object value) throws DatalakeStorageException {
        boolean result = false;
        try {
            JSONObject jsonValue = new JSONObject();
            jsonValue.put("value", value);
            jsonValue.put("timestamp", DatalakeStorage.generateDate());
            JSONObject scriptParam = new JSONObject();
            scriptParam.put("source", "ctx._source." + key + " = params.value; ctx._source['@timestamp'] = params.timestamp");
            scriptParam.put("lang", "painless");
            scriptParam.put("params", jsonValue);
            JSONObject messageBody = new JSONObject();
            messageBody.put("script", scriptParam);
            HttpResponse res = ((RequestBodyEntity)((HttpRequestWithBody)Unirest.post((String)String.format("%s/%s/_update/%s?retry_on_conflict=10", elasticSearchUrl, index, id)).header("Content-Type", "application/json")).body((JSONElement)messageBody).basicAuth(elasticSearchUser, elasticSearchPassword)).asEmpty();
            if (res.getStatus() != DatalakeStorageResponseCode.HTTP_OK) {
                LogManager.getLogger(DatalakeStorageItem.class).info(String.format("UpsertField (%s) from index %s status : %d body : %s", id, index, res.getStatus(), res.getBody()));
            }
            result = res.getStatus() == DatalakeStorageResponseCode.HTTP_OK;
        }
        catch (Exception ex) {
            LogManager.getLogger(DatalakeStorageItem.class).error(String.format("UpsertField (%s) from index %s (Key : %s) (Value : %s) : %s", id, index, key, value, ex.getMessage()));
            throw new DatalakeStorageException(String.format("UpsertField (%s) from index %s (Key : %s) (Value : %s) : %s", id, index, key, value, ex.getMessage()), ex);
        }
        return result;
    }

    public static boolean removeObjectField(DatalakeStorageItem item, String key) throws DatalakeStorageException {
        boolean result = false;
        try {
            JSONObject jsonValue = new JSONObject();
            jsonValue.put("timestamp", DatalakeStorage.generateDate());
            JSONObject scriptParam = new JSONObject();
            scriptParam.put("source", "ctx._source.remove('" + key + "'); ctx._source['@timestamp'] = params.timestamp");
            scriptParam.put("lang", "painless");
            scriptParam.put("params", jsonValue);
            JSONObject messageBody = new JSONObject();
            messageBody.put("script", scriptParam);
            HttpResponse res = ((RequestBodyEntity)((HttpRequestWithBody)Unirest.post((String)String.format("%s/%s/_update/%s?retry_on_conflict=10", elasticSearchUrl, item.getIndex(), item.getId())).header("Content-Type", "application/json")).body((JSONElement)messageBody).basicAuth(elasticSearchUser, elasticSearchPassword)).asEmpty();
            if (res.getStatus() != DatalakeStorageResponseCode.HTTP_OK) {
                LogManager.getLogger(DatalakeStorageItem.class).info(String.format("RemoveField (%s) from index %s status : %d body : %s", item.getId(), item.getIndex(), res.getStatus(), res.getBody()));
            }
            result = res.getStatus() == DatalakeStorageResponseCode.HTTP_OK;
        }
        catch (Exception ex) {
            LogManager.getLogger(DatalakeStorageItem.class).error(String.format("RemoveField (%s) from index %s (Key : %s) : %s", item.getId(), item.getIndex(), key, ex.getMessage()));
            throw new DatalakeStorageException(String.format("RemoveField (%s) from index %s (Key : %s) : %s", item.getId(), item.getIndex(), key, ex.getMessage()), ex);
        }
        return result;
    }

    private static String generateDate() {
        return simpleDateFormat.format(new Date());
    }
}

