/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.json;

import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;

public class JsonUtils {
    public static String getSafeString(JSONObject json, String key) {
        String safeString = "";
        if (json != null && json.has(key) && !json.isNull(key)) {
            safeString = json.getString(key);
        }
        return safeString;
    }

    public static void setSafeString(JSONObject json, String key, String value) {
        if (json != null && key != null && value != null) {
            json.put(key, value);
        }
    }

    public static int getSafeInt(JSONObject json, String key) {
        int safeInt = -1;
        if (json != null && json.has(key) && !json.isNull(key)) {
            safeInt = json.getInt(key);
        }
        return safeInt;
    }

    public static void setSafeInt(JSONObject json, String key, int value) {
        if (json != null && key != null) {
            json.put(key, value);
        }
    }

    public static boolean getSafeBoolean(JSONObject json, String key) {
        boolean safeBoolean = false;
        if (json != null && json.has(key) && !json.isNull(key)) {
            safeBoolean = json.getBoolean(key);
        }
        return safeBoolean;
    }

    public static void setSafeBoolean(JSONObject json, String key, Boolean value) {
        if (json != null && key != null) {
            json.put(key, (Object)value);
        }
    }

    public static String[] getSafeStringArray(JSONObject json, String key) {
        String[] safeArray = new String[]{};
        if (json != null && json.has(key) && !json.isNull(key)) {
            JSONArray jsonArray = json.getJSONArray(key);
            safeArray = new String[jsonArray.length()];
            int i = 0;
            while (i < jsonArray.length()) {
                safeArray[i] = jsonArray.getString(i);
                ++i;
            }
        }
        return safeArray;
    }

    public static void setSafeStringArray(JSONObject json, String key, String[] values) {
        if (json != null && key != null) {
            JSONArray jsonArray = new JSONArray();
            if (values != null) {
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    jsonArray.put(value);
                    ++n2;
                }
            }
            json.put(key, jsonArray);
        }
    }
}

