/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.mantisbt;

import biz.futureware.mantisconnect.CustomFieldValueForIssueData;
import biz.futureware.mantisconnect.FilterCustomField;
import biz.futureware.mantisconnect.FilterSearchData;
import biz.futureware.mantisconnect.IssueData;
import biz.futureware.mantisconnect.IssueNoteData;
import biz.futureware.mantisconnect.MantisConnectLocator;
import biz.futureware.mantisconnect.MantisConnectPortType;
import biz.futureware.mantisconnect.ObjectRef;
import biz.futureware.mantisconnect.TagData;
import com.michelin.cert.redscan.utils.models.reports.Vulnerability;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.logging.log4j.LogManager;

public class MantisBtClient {
    private static String url;
    private static String username;
    private static String password;
    private static MantisConnectLocator mantisConnectLocator;
    private static MantisConnectPortType mantisConnectPort;
    private static final BigInteger REDSCAN_PROJECT_ID;
    private static final BigInteger INTERNAL_ID_CUSTOMFIELD_ID;
    private static final BigInteger URL_CUSTOMFIELD_ID;
    private static final BigInteger ORIGIN_CUSTOMFIELD_ID;
    private static final BigInteger SEVERITY_CRITICAL;
    private static final BigInteger SEVERITY_HIGH;
    private static final BigInteger SEVERITY_MEDIUM;
    private static final BigInteger SEVERITY_LOW;
    private static final BigInteger SEVERITY_INFO;
    private static final BigInteger PRIORITY_P1;
    private static final BigInteger PRIORITY_P2;
    private static final BigInteger PRIORITY_P3;
    private static final BigInteger PRIORITY_P4;
    private static final BigInteger PRIORITY_P5;
    private static final BigInteger RESOLUTION_REOPEN;
    private static final BigInteger RESOLUTION_WONTFIX;
    private static final BigInteger STATUS_NEW;
    private static final BigInteger STATUS_TOVERIFY;
    private static final BigInteger STATUS_CLOSED;
    private static final String DEFAULT_CATEGORY = "General";
    private static final String REDSCAN_PROJECT_NAME = "Redscan";

    static {
        REDSCAN_PROJECT_ID = BigInteger.ONE;
        INTERNAL_ID_CUSTOMFIELD_ID = BigInteger.ONE;
        URL_CUSTOMFIELD_ID = BigInteger.valueOf(2L);
        ORIGIN_CUSTOMFIELD_ID = BigInteger.valueOf(3L);
        SEVERITY_CRITICAL = BigInteger.valueOf(1L);
        SEVERITY_HIGH = BigInteger.valueOf(2L);
        SEVERITY_MEDIUM = BigInteger.valueOf(3L);
        SEVERITY_LOW = BigInteger.valueOf(4L);
        SEVERITY_INFO = BigInteger.valueOf(5L);
        PRIORITY_P1 = BigInteger.valueOf(1L);
        PRIORITY_P2 = BigInteger.valueOf(2L);
        PRIORITY_P3 = BigInteger.valueOf(3L);
        PRIORITY_P4 = BigInteger.valueOf(4L);
        PRIORITY_P5 = BigInteger.valueOf(5L);
        RESOLUTION_REOPEN = BigInteger.valueOf(30L);
        RESOLUTION_WONTFIX = BigInteger.valueOf(90L);
        STATUS_NEW = BigInteger.valueOf(10L);
        STATUS_TOVERIFY = BigInteger.valueOf(70L);
        STATUS_CLOSED = BigInteger.valueOf(90L);
    }

    public static void init(String url, String username, String password) {
        MantisBtClient.url = url;
        MantisBtClient.username = username;
        MantisBtClient.password = password;
    }

    public String getMantisVersion() {
        String version = "";
        try {
            version = this.getClient().mc_version();
        }
        catch (RemoteException ex) {
            LogManager.getLogger(MantisBtClient.class).error(String.format("RemoteException : %s", ex.getMessage()));
        }
        return version;
    }

    public IssueData getIssue(BigInteger id) {
        LogManager.getLogger(MantisBtClient.class).info(String.format("Get issue id : %s", id.toString()));
        IssueData issueData = null;
        try {
            issueData = this.getClient().mc_issue_get(username, password, id);
        }
        catch (Exception ex) {
            LogManager.getLogger(MantisBtClient.class).error(String.format("Exception : %s", ex.getMessage()));
        }
        return issueData;
    }

    public IssueData[] getIssuesByInternalId(String id) {
        LogManager.getLogger(MantisBtClient.class).info(String.format("Get issue with internal id : %s", id));
        IssueData[] issueDatas = null;
        try {
            FilterSearchData filter = new FilterSearchData();
            filter.setCustom_fields(new FilterCustomField[]{new FilterCustomField(new ObjectRef(INTERNAL_ID_CUSTOMFIELD_ID, "InternalID"), new String[]{id})});
            issueDatas = this.getClient().mc_filter_search_issues(username, password, filter, BigInteger.valueOf(1L), BigInteger.valueOf(-1L));
        }
        catch (Exception ex) {
            LogManager.getLogger(MantisBtClient.class).error(String.format("Exception : %s", ex.getMessage()));
        }
        return issueDatas;
    }

    public boolean deleteIssue(BigInteger id) {
        boolean result = false;
        try {
            LogManager.getLogger(MantisBtClient.class).info(String.format("Delete issue id : %s", id.toString()));
            result = this.getClient().mc_issue_delete(username, password, id);
        }
        catch (NullPointerException ex) {
            result = true;
        }
        catch (Exception ex) {
            LogManager.getLogger(MantisBtClient.class).error(String.format("Exception : %s", ex.getMessage()));
        }
        return result;
    }

    public boolean shouldBeReopened(IssueData issue) {
        return issue != null && (issue.getStatus().getId().compareTo(STATUS_CLOSED) == 0 || issue.getStatus().getId().compareTo(STATUS_TOVERIFY) == 0) && issue.getResolution().getId().compareTo(RESOLUTION_WONTFIX) != 0;
    }

    public boolean reopenTicket(BigInteger id) {
        boolean result = false;
        try {
            LogManager.getLogger(MantisBtClient.class).info(String.format("Reopened issue id : %s", id.toString()));
            IssueData issueData = this.getIssue(id);
            issueData.setStatus(new ObjectRef(STATUS_NEW, "new"));
            issueData.setResolution(new ObjectRef(RESOLUTION_REOPEN, "reopened"));
            result = this.getClient().mc_issue_update(username, password, id, issueData);
        }
        catch (Exception ex) {
            LogManager.getLogger(MantisBtClient.class).error(String.format("Exception : %s", ex.getMessage()));
        }
        return result;
    }

    public BigInteger addComment(BigInteger id, String comment) {
        BigInteger noteId = null;
        try {
            LogManager.getLogger(MantisBtClient.class).info(String.format("Add comment to issue id : %s", id.toString()));
            IssueNoteData issueNoteData = new IssueNoteData();
            issueNoteData.setText(comment);
            noteId = this.getClient().mc_issue_note_add(username, password, id, issueNoteData);
        }
        catch (Exception ex) {
            LogManager.getLogger(MantisBtClient.class).error(String.format("Exception : %s", ex.getMessage()));
        }
        return noteId;
    }

    public BigInteger createIssue(Vulnerability vulnerability) {
        BigInteger result = null;
        try {
            LogManager.getLogger(MantisBtClient.class).info(String.format("Create issue for : %s", vulnerability.getId()));
            IssueData issue = new IssueData();
            issue.setProject(new ObjectRef(REDSCAN_PROJECT_ID, REDSCAN_PROJECT_NAME));
            issue.setCategory(DEFAULT_CATEGORY);
            issue.setSummary(vulnerability.getSummary());
            issue.setDescription(vulnerability.getDescription());
            issue.setTags(this.manageTags(vulnerability.getTags()));
            issue.setSeverity(this.manageSeverity(vulnerability.getSeverity()));
            issue.setPriority(this.managePriority(vulnerability.getSeverity()));
            CustomFieldValueForIssueData[] customFields = new CustomFieldValueForIssueData[]{new CustomFieldValueForIssueData(new ObjectRef(URL_CUSTOMFIELD_ID, "Url"), vulnerability.getUrl()), new CustomFieldValueForIssueData(new ObjectRef(ORIGIN_CUSTOMFIELD_ID, "Origin"), vulnerability.getOrigin()), new CustomFieldValueForIssueData(new ObjectRef(INTERNAL_ID_CUSTOMFIELD_ID, "InternalID"), vulnerability.getId())};
            issue.setCustom_fields(customFields);
            result = this.getClient().mc_issue_add(username, password, issue);
        }
        catch (Exception ex) {
            LogManager.getLogger(MantisBtClient.class).error(String.format("Exception : %s", ex.getMessage()));
        }
        return result;
    }

    private MantisConnectPortType getClient() {
        if (mantisConnectLocator == null || mantisConnectPort == null) {
            try {
                LogManager.getLogger(MantisBtClient.class).info(String.format("SOAP url : %s", url));
                mantisConnectLocator = new MantisConnectLocator();
                mantisConnectPort = mantisConnectLocator.getMantisConnectPort(new URL(url));
            }
            catch (MalformedURLException ex) {
                LogManager.getLogger(MantisBtClient.class).error(String.format("Malformed SOAP url : %s", ex.getMessage()));
            }
            catch (ServiceException ex) {
                LogManager.getLogger(MantisBtClient.class).error(String.format("Service Exception : %s", ex.getMessage()));
            }
        }
        return mantisConnectPort;
    }

    private ObjectRef[] manageTags(String[] tags) {
        ObjectRef[] issueTags = null;
        try {
            String[] cleanTags = (String[])Arrays.stream(tags).distinct().toArray(String[]::new);
            List<TagData> existingTags = Arrays.asList(this.getClient().mc_tag_get_all(username, password, BigInteger.valueOf(1L), BigInteger.valueOf(-1L)).getResults());
            issueTags = new ObjectRef[cleanTags.length];
            int i = 0;
            while (i < cleanTags.length) {
                String tag = cleanTags[i];
                TagData existingTag = existingTags.stream().filter(temp -> tag.equals(temp.getName())).findAny().orElse(null);
                if (existingTag == null) {
                    existingTag = new TagData();
                    existingTag.setName(tag);
                    existingTag.setId(this.getClient().mc_tag_add(username, password, existingTag));
                }
                issueTags[i] = new ObjectRef(existingTag.getId(), existingTag.getName());
                ++i;
            }
        }
        catch (Exception ex) {
            LogManager.getLogger(MantisBtClient.class).error(String.format("Exception : %s", ex.getMessage()));
            issueTags = null;
        }
        return issueTags;
    }

    private ObjectRef manageSeverity(int severity) {
        ObjectRef result = null;
        switch (severity) {
            case 1: {
                result = new ObjectRef(SEVERITY_CRITICAL, "Critical");
                break;
            }
            case 2: {
                result = new ObjectRef(SEVERITY_HIGH, "High");
                break;
            }
            case 3: {
                result = new ObjectRef(SEVERITY_MEDIUM, "Medium");
                break;
            }
            case 4: {
                result = new ObjectRef(SEVERITY_LOW, "Low");
                break;
            }
            case 5: {
                result = new ObjectRef(SEVERITY_INFO, "Info");
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private ObjectRef managePriority(int severity) {
        ObjectRef result = null;
        switch (severity) {
            case 1: {
                result = new ObjectRef(PRIORITY_P1, "P1");
                break;
            }
            case 2: {
                result = new ObjectRef(PRIORITY_P2, "P2");
                break;
            }
            case 3: {
                result = new ObjectRef(PRIORITY_P3, "P3");
                break;
            }
            case 4: {
                result = new ObjectRef(PRIORITY_P4, "P4");
                break;
            }
            case 5: {
                result = new ObjectRef(PRIORITY_P5, "P5");
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

