/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.models;

import com.michelin.cert.redscan.utils.datalake.DatalakeStorageException;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageItem;
import com.michelin.cert.redscan.utils.json.JsonUtils;
import com.michelin.cert.redscan.utils.models.Sendable;
import kong.unirest.json.JSONObject;

public class Domain
extends DatalakeStorageItem
implements Sendable {
    private String name;

    public Domain() {
        this.index = "domains";
    }

    public Domain(String name) {
        this();
        this.name = name;
    }

    public Domain(String name, String parent) {
        this();
        this.name = name;
        this.parent = parent;
    }

    public Domain(String name, String parent, boolean blocked) {
        this(name, parent);
        this.setBlocked(blocked);
    }

    @Override
    public String getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        JsonUtils.setSafeString(jsonObject, "name", this.name);
        JsonUtils.setSafeString(jsonObject, "parent", this.parent);
        JsonUtils.setSafeBoolean(jsonObject, "blocked", this.getBlocked());
        return jsonObject.toString();
    }

    @Override
    public void fromJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        this.name = JsonUtils.getSafeString(jsonObject, "name");
        this.parent = JsonUtils.getSafeString(jsonObject, "parent");
        this.setBlocked(JsonUtils.getSafeBoolean(jsonObject, "blocked"));
    }

    @Override
    public String getFanoutExchangeName() {
        return "com.michelin.cert.fanout.domains";
    }

    @Override
    public <T extends DatalakeStorageItem> T fromDatalake(JSONObject object) {
        return (T)(object == null ? null : new Domain(JsonUtils.getSafeString(object, "name"), JsonUtils.getSafeString(object, "parent"), JsonUtils.getSafeBoolean(object, "blocked")));
    }

    @Override
    public boolean upsert() throws DatalakeStorageException {
        boolean result;
        boolean bl = result = this.find() != null;
        if (result) {
            result &= this.upsertField("name", this.name);
            result &= this.upsertField("blocked", this.getBlocked());
        }
        return result;
    }
}

