/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.models;

import com.michelin.cert.redscan.utils.datalake.DatalakeStorageException;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageItem;
import com.michelin.cert.redscan.utils.json.JsonUtils;
import com.michelin.cert.redscan.utils.models.Sendable;
import java.util.Date;
import kong.unirest.json.JSONObject;

public class MasterDomain
extends DatalakeStorageItem
implements Sendable {
    private String name;
    private int serviceLevel;
    private boolean inScope;
    private boolean reviewed;

    public MasterDomain() {
        this.index = "master_domains";
    }

    public MasterDomain(String name) {
        this();
        this.name = name;
    }

    public MasterDomain(String name, String parent) {
        this();
        this.name = name;
        this.parent = parent;
    }

    public MasterDomain(String name, int serviceLevel, boolean inScope, boolean reviewed, Date lastScanDate, String parent) {
        this(name, parent);
        this.serviceLevel = serviceLevel;
        this.inScope = inScope;
        this.reviewed = reviewed;
        this.setLastScanDate(lastScanDate);
    }

    @Override
    public String getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isInScope() {
        return this.inScope;
    }

    public void setInScope(boolean inScope) {
        this.inScope = inScope;
    }

    public boolean isReviewed() {
        return this.reviewed;
    }

    public void setReviewed(boolean reviewed) {
        this.reviewed = reviewed;
    }

    public int getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(int serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    @Override
    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        JsonUtils.setSafeString(jsonObject, "name", this.name);
        JsonUtils.setSafeInt(jsonObject, "serviceLevel", this.serviceLevel);
        JsonUtils.setSafeString(jsonObject, "parent", this.parent);
        return jsonObject.toString();
    }

    @Override
    public void fromJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        this.name = JsonUtils.getSafeString(jsonObject, "name");
        this.serviceLevel = JsonUtils.getSafeInt(jsonObject, "serviceLevel");
        this.parent = JsonUtils.getSafeString(jsonObject, "parent");
    }

    @Override
    public String getFanoutExchangeName() {
        return "com.michelin.cert.fanout.masterdomains";
    }

    @Override
    public <T extends DatalakeStorageItem> T fromDatalake(JSONObject object) {
        return (T)(object == null ? null : new MasterDomain(JsonUtils.getSafeString(object, "name"), JsonUtils.getSafeInt(object, "serviceLevel"), JsonUtils.getSafeBoolean(object, "inScope"), JsonUtils.getSafeBoolean(object, "reviewed"), MasterDomain.toDate(JsonUtils.getSafeString(object, "last_scan_date")), JsonUtils.getSafeString(object, "parent")));
    }

    @Override
    public boolean upsert() throws DatalakeStorageException {
        boolean result;
        boolean bl = result = this.find() != null;
        if (result) {
            result &= this.upsertField("name", this.name);
            result &= this.upsertField("serviceLevel", this.serviceLevel);
            result &= this.upsertField("inScope", this.inScope);
            result &= this.upsertField("reviewed", this.reviewed);
            result &= this.upsertField("last_scan_date", MasterDomain.fromDate(this.getLastScanDate()));
        }
        return result;
    }
}

