/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.models.reports;

import com.michelin.cert.redscan.utils.datalake.DatalakeStorageException;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageItem;
import com.michelin.cert.redscan.utils.json.JsonUtils;
import com.michelin.cert.redscan.utils.models.Sendable;
import java.util.Arrays;
import kong.unirest.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;

public class Vulnerability
extends DatalakeStorageItem
implements Sendable {
    private int severity;
    private String id;
    private String summary;
    private String description;
    private String url;
    private String origin;
    private String[] tags;

    public Vulnerability() {
        this.index = "vulnerabilities";
        this.severity = 5;
        this.id = "";
        this.summary = "";
        this.description = "";
        this.url = "";
        this.origin = "";
        this.tags = new String[0];
    }

    public Vulnerability(String id, int severity, String summary, String description, String url, String origin, String[] tags) {
        this.severity = severity;
        this.id = id;
        this.summary = summary;
        this.description = description;
        this.url = url;
        this.origin = origin;
        this.tags = tags;
    }

    @Override
    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        JsonUtils.setSafeString(jsonObject, "id", this.id);
        JsonUtils.setSafeInt(jsonObject, "severity", this.severity);
        JsonUtils.setSafeString(jsonObject, "summary", this.summary);
        JsonUtils.setSafeString(jsonObject, "description", this.description);
        JsonUtils.setSafeString(jsonObject, "url", this.url);
        JsonUtils.setSafeString(jsonObject, "origin", this.origin);
        JsonUtils.setSafeStringArray(jsonObject, "tags", this.tags);
        return jsonObject.toString();
    }

    @Override
    public void fromJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        this.id = JsonUtils.getSafeString(jsonObject, "id");
        this.severity = JsonUtils.getSafeInt(jsonObject, "severity");
        this.summary = JsonUtils.getSafeString(jsonObject, "summary");
        this.description = JsonUtils.getSafeString(jsonObject, "description");
        this.url = JsonUtils.getSafeString(jsonObject, "url");
        this.origin = JsonUtils.getSafeString(jsonObject, "origin");
        this.tags = JsonUtils.getSafeStringArray(jsonObject, "tags");
    }

    @Override
    public String getFanoutExchangeName() {
        return "com.michelin.cert.fanout.vulnerabilities";
    }

    @Override
    public boolean upsert() throws DatalakeStorageException {
        boolean result;
        boolean bl = result = this.find() != null;
        if (result) {
            result &= this.upsertField("id", this.id);
            result &= this.upsertField("severity", this.severity);
            result &= this.upsertField("summary", this.summary);
            result &= this.upsertField("description", this.description);
            result &= this.upsertField("url", this.url);
            result &= this.upsertField("origin", this.origin);
            result &= this.upsertField("tags", this.tags);
        }
        return result;
    }

    @Override
    protected <T extends DatalakeStorageItem> T fromDatalake(JSONObject object) {
        return (T)(object == null ? null : new Vulnerability(JsonUtils.getSafeString(object, "id"), JsonUtils.getSafeInt(object, "severity"), JsonUtils.getSafeString(object, "summary"), JsonUtils.getSafeString(object, "description"), JsonUtils.getSafeString(object, "url"), JsonUtils.getSafeString(object, "origin"), JsonUtils.getSafeStringArray(object, "tags")));
    }

    public static String generateId(String ... values) {
        String result = "";
        if (values != null && values.length > 0) {
            result = DigestUtils.sha1Hex((String)Arrays.toString(values));
        }
        return result;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }
}

