/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.models.services;

import com.michelin.cert.redscan.utils.datalake.DatalakeStorageException;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageItem;
import com.michelin.cert.redscan.utils.json.JsonUtils;
import com.michelin.cert.redscan.utils.models.Sendable;
import kong.unirest.json.JSONObject;

public class HttpService
extends DatalakeStorageItem
implements Sendable {
    private String domain;
    private String ip;
    private String port;
    private boolean ssl;

    public HttpService() {
        this.index = "http_services";
        this.ssl = false;
    }

    public HttpService(String domain, String ip, String port, boolean isSsl) {
        this();
        this.domain = domain;
        this.ip = ip;
        this.port = port;
        this.ssl = isSsl;
    }

    public HttpService(String domain, String ip, String port, String parent, boolean isSsl) {
        this(domain, ip, port, isSsl);
        this.parent = parent;
    }

    public String toUrl() {
        return String.format("%s%s:%s", this.ssl ? "https://" : "http://", this.getDomain(), this.getPort());
    }

    @Override
    public void fromJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        this.domain = JsonUtils.getSafeString(jsonObject, "domain");
        this.ip = JsonUtils.getSafeString(jsonObject, "ip");
        this.port = JsonUtils.getSafeString(jsonObject, "port");
        this.ssl = JsonUtils.getSafeBoolean(jsonObject, "ssl");
    }

    @Override
    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        JsonUtils.setSafeString(jsonObject, "domain", this.domain);
        JsonUtils.setSafeString(jsonObject, "ip", this.ip);
        JsonUtils.setSafeString(jsonObject, "port", this.port);
        JsonUtils.setSafeBoolean(jsonObject, "ssl", this.ssl);
        return jsonObject.toString();
    }

    @Override
    public String getId() {
        return String.format("%s_%s_%s", this.getDomain(), this.getPort(), this.ssl ? "https" : "http");
    }

    @Override
    public String getFanoutExchangeName() {
        return "com.michelin.cert.fanout.httpservices";
    }

    @Override
    public <T extends DatalakeStorageItem> T fromDatalake(JSONObject object) {
        return (T)(object == null ? null : new HttpService(JsonUtils.getSafeString(object, "domain"), JsonUtils.getSafeString(object, "ip"), JsonUtils.getSafeString(object, "port"), JsonUtils.getSafeString(object, "parent"), JsonUtils.getSafeBoolean(object, "ssl")));
    }

    @Override
    public boolean upsert() throws DatalakeStorageException {
        boolean result;
        boolean bl = result = this.find() != null;
        if (result) {
            result &= this.upsertField("domain", this.domain);
            result &= this.upsertField("ip", this.ip);
            result &= this.upsertField("port", this.port);
            result &= this.upsertField("ssl", this.ssl);
        }
        return result;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean isSsl) {
        this.ssl = isSsl;
    }
}

