/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.system;

import com.michelin.cert.redscan.utils.system.StreamGobbler;
import java.io.File;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;

public class OsCommandExecutor {
    public StreamGobbler execute(String command) {
        return this.execute(command, null, false);
    }

    public StreamGobbler execute(String command, boolean flushInput) {
        return this.execute(command, null, flushInput);
    }

    public StreamGobbler execute(String command, File executionDir) {
        return this.execute(command, executionDir, false);
    }

    public StreamGobbler execute(String command, File executionDir, boolean flushInput) {
        StreamGobbler streamGobbler = null;
        try {
            Process process = Runtime.getRuntime().exec(command, null, executionDir);
            if (flushInput) {
                process.getOutputStream().flush();
                process.getOutputStream().close();
            }
            streamGobbler = new StreamGobbler(process.getInputStream(), process.getErrorStream());
            Executors.newSingleThreadExecutor().submit(streamGobbler);
            streamGobbler.setExitStatus(process.waitFor());
        }
        catch (Exception ex) {
            LogManager.getLogger(OsCommandExecutor.class).error(String.format("Exception : %s", ex.getMessage()));
        }
        return streamGobbler;
    }
}

