/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.authentication.entraid;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentityId;
import com.microsoft.aad.msal4j.ManagedIdentityParameters;
import java.net.MalformedURLException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import redis.clients.authentication.core.IdentityProvider;
import redis.clients.authentication.core.Token;
import redis.clients.authentication.entraid.JWToken;
import redis.clients.authentication.entraid.ManagedIdentityInfo;
import redis.clients.authentication.entraid.RedisEntraIDException;
import redis.clients.authentication.entraid.ServicePrincipalInfo;

public final class EntraIDIdentityProvider
implements IdentityProvider {
    private ClientAppFactory clientAppFactory;
    private ClientApp clientApp;

    public EntraIDIdentityProvider(ServicePrincipalInfo servicePrincipalInfo, Set<String> scopes, int timeout) {
        this.clientAppFactory = () -> this.createConfidentialClientApp(servicePrincipalInfo, scopes, timeout);
    }

    private ClientApp createConfidentialClientApp(ServicePrincipalInfo servicePrincipalInfo, Set<String> scopes, int timeout) {
        ConfidentialClientApplication app;
        IClientCredential credential = this.getClientCredential(servicePrincipalInfo);
        try {
            String authority = servicePrincipalInfo.getAuthority();
            authority = authority == null ? "https://login.microsoftonline.com/common/" : authority;
            app = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)servicePrincipalInfo.getClientId(), (IClientCredential)credential).authority(authority)).readTimeoutForDefaultHttpClient(Integer.valueOf(timeout))).build();
        }
        catch (MalformedURLException e) {
            throw new RedisEntraIDException("Failed to init EntraID client!", e);
        }
        ClientCredentialParameters params = ClientCredentialParameters.builder(scopes).skipCache(Boolean.valueOf(true)).build();
        return () -> this.requestWithConfidentialClient(app, params);
    }

    public EntraIDIdentityProvider(ManagedIdentityInfo info, Set<String> scopes, int timeout) {
        this.clientAppFactory = () -> this.createManagedIdentityApp(info, scopes, timeout);
    }

    private ClientApp createManagedIdentityApp(ManagedIdentityInfo info, Set<String> scopes, int timeout) {
        ManagedIdentityApplication app = ((ManagedIdentityApplication.Builder)ManagedIdentityApplication.builder((ManagedIdentityId)info.getId()).readTimeoutForDefaultHttpClient(Integer.valueOf(timeout))).build();
        ManagedIdentityParameters params = ManagedIdentityParameters.builder((String)scopes.iterator().next()).forceRefresh(true).build();
        return () -> this.requestWithManagedIdentity(app, params);
    }

    public EntraIDIdentityProvider(Supplier<IAuthenticationResult> customEntraIdAuthenticationSupplier) {
        this.clientAppFactory = () -> () -> EntraIDIdentityProvider.lambda$null$4((Supplier)customEntraIdAuthenticationSupplier);
    }

    private IClientCredential getClientCredential(ServicePrincipalInfo servicePrincipalInfo) {
        switch (servicePrincipalInfo.getAccessWith()) {
            case WithSecret: {
                return ClientCredentialFactory.createFromSecret((String)servicePrincipalInfo.getSecret());
            }
            case WithCert: {
                return ClientCredentialFactory.createFromCertificate((PrivateKey)servicePrincipalInfo.getKey(), (X509Certificate)servicePrincipalInfo.getCert());
            }
        }
        throw new RedisEntraIDException("Invalid ServicePrincipalAccess type!");
    }

    public Token requestToken() {
        this.clientApp = this.clientApp == null ? this.clientAppFactory.create() : this.clientApp;
        return new JWToken(this.clientApp.request().accessToken());
    }

    public IAuthenticationResult requestWithConfidentialClient(ConfidentialClientApplication app, ClientCredentialParameters params) {
        try {
            CompletableFuture tokenRequest = app.acquireToken(params);
            return (IAuthenticationResult)tokenRequest.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RedisEntraIDException("Failed to acquire token!", e);
        }
    }

    public IAuthenticationResult requestWithManagedIdentity(ManagedIdentityApplication app, ManagedIdentityParameters params) {
        try {
            CompletableFuture tokenRequest = app.acquireTokenForManagedIdentity(params);
            return (IAuthenticationResult)tokenRequest.get();
        }
        catch (Exception e) {
            throw new RedisEntraIDException("Failed to acquire token!", e);
        }
    }

    private static /* synthetic */ IAuthenticationResult lambda$null$4(Supplier customEntraIdAuthenticationSupplier) {
        return (IAuthenticationResult)customEntraIdAuthenticationSupplier.get();
    }

    private static interface ClientAppFactory {
        public ClientApp create();
    }

    private static interface ClientApp {
        public IAuthenticationResult request();
    }
}

