/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.authentication.entraid;

import com.microsoft.aad.msal4j.IAuthenticationResult;
import java.util.Set;
import java.util.function.Supplier;
import redis.clients.authentication.core.IdentityProvider;
import redis.clients.authentication.core.IdentityProviderConfig;
import redis.clients.authentication.entraid.EntraIDIdentityProvider;
import redis.clients.authentication.entraid.ManagedIdentityInfo;
import redis.clients.authentication.entraid.ServicePrincipalInfo;

public final class EntraIDIdentityProviderConfig
implements IdentityProviderConfig {
    private final Supplier<IdentityProvider> providerSupplier;

    public EntraIDIdentityProviderConfig(ServicePrincipalInfo info, Set<String> scopes, int timeout) {
        this.providerSupplier = () -> new EntraIDIdentityProvider(info, scopes, timeout);
    }

    public EntraIDIdentityProviderConfig(ManagedIdentityInfo info, Set<String> scopes, int timeout) {
        this.providerSupplier = () -> new EntraIDIdentityProvider(info, scopes, timeout);
    }

    public EntraIDIdentityProviderConfig(Supplier<IAuthenticationResult> customEntraIdAuthenticationSupplier) {
        this.providerSupplier = () -> new EntraIDIdentityProvider(customEntraIdAuthenticationSupplier);
    }

    public IdentityProvider getProvider() {
        IdentityProvider identityProvider = this.providerSupplier.get();
        return identityProvider;
    }
}

