/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.authentication.entraid;

import com.microsoft.aad.msal4j.IAuthenticationResult;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.function.Supplier;
import redis.clients.authentication.core.IdentityProviderConfig;
import redis.clients.authentication.core.TokenAuthConfig;
import redis.clients.authentication.core.TokenManagerConfig;
import redis.clients.authentication.entraid.EntraIDIdentityProviderConfig;
import redis.clients.authentication.entraid.ManagedIdentityInfo;
import redis.clients.authentication.entraid.RedisEntraIDException;
import redis.clients.authentication.entraid.ServicePrincipalInfo;

public class EntraIDTokenAuthConfigBuilder
extends TokenAuthConfig.Builder<EntraIDTokenAuthConfigBuilder>
implements AutoCloseable {
    public static final float DEFAULT_EXPIRATION_REFRESH_RATIO = 0.75f;
    public static final int DEFAULT_LOWER_REFRESH_BOUND_MILLIS = 120000;
    public static final int DEFAULT_TOKEN_REQUEST_EXECUTION_TIMEOUT_IN_MS = 1000;
    public static final int DEFAULT_MAX_ATTEMPTS_TO_RETRY = 5;
    public static final int DEFAULT_DELAY_IN_MS_TO_RETRY = 100;
    private String clientId;
    private String secret;
    private PrivateKey key;
    private X509Certificate cert;
    private String authority;
    private Set<String> scopes;
    private ServicePrincipalInfo.ServicePrincipalAccess accessWith;
    private ManagedIdentityInfo mii;
    private int tokenRequestExecTimeoutInMs;
    private Supplier<IAuthenticationResult> customEntraIdAuthenticationSupplier;

    public EntraIDTokenAuthConfigBuilder() {
        ((EntraIDTokenAuthConfigBuilder)((EntraIDTokenAuthConfigBuilder)((EntraIDTokenAuthConfigBuilder)this.expirationRefreshRatio(0.75f)).lowerRefreshBoundMillis(120000)).tokenRequestExecTimeoutInMs(1000).maxAttemptsToRetry(5)).delayInMsToRetry(100);
    }

    public EntraIDTokenAuthConfigBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public EntraIDTokenAuthConfigBuilder secret(String secret) {
        this.secret = secret;
        this.accessWith = ServicePrincipalInfo.ServicePrincipalAccess.WithSecret;
        return this;
    }

    public EntraIDTokenAuthConfigBuilder key(PrivateKey key, X509Certificate cert) {
        this.key = key;
        this.cert = cert;
        this.accessWith = ServicePrincipalInfo.ServicePrincipalAccess.WithCert;
        return this;
    }

    public EntraIDTokenAuthConfigBuilder authority(String authority) {
        this.authority = authority;
        return this;
    }

    public EntraIDTokenAuthConfigBuilder systemAssignedManagedIdentity() {
        this.mii = new ManagedIdentityInfo();
        return this;
    }

    public EntraIDTokenAuthConfigBuilder userAssignedManagedIdentity(ManagedIdentityInfo.UserManagedIdentityType userManagedType, String id) {
        this.mii = new ManagedIdentityInfo(userManagedType, id);
        return this;
    }

    public EntraIDTokenAuthConfigBuilder customEntraIdAuthenticationSupplier(Supplier<IAuthenticationResult> customEntraIdAuthenticationSupplier) {
        this.customEntraIdAuthenticationSupplier = customEntraIdAuthenticationSupplier;
        return this;
    }

    public EntraIDTokenAuthConfigBuilder scopes(Set<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public EntraIDTokenAuthConfigBuilder tokenRequestExecTimeoutInMs(int tokenRequestExecTimeoutInMs) {
        super.tokenRequestExecTimeoutInMs(tokenRequestExecTimeoutInMs);
        this.tokenRequestExecTimeoutInMs = tokenRequestExecTimeoutInMs;
        return this;
    }

    public TokenAuthConfig build() {
        ServicePrincipalInfo spi = null;
        if (this.key != null || this.cert != null || this.secret != null) {
            switch (this.accessWith) {
                case WithCert: {
                    spi = new ServicePrincipalInfo(this.clientId, this.key, this.cert, this.authority);
                    break;
                }
                case WithSecret: {
                    spi = new ServicePrincipalInfo(this.clientId, this.secret, this.authority);
                }
            }
        }
        if (spi != null && this.mii != null) {
            throw new RedisEntraIDException("Cannot have both ServicePrincipal and ManagedIdentity!");
        }
        if (this.customEntraIdAuthenticationSupplier != null && (spi != null || this.mii != null)) {
            throw new RedisEntraIDException("Cannot have both customEntraIdAuthenticationSupplier and ServicePrincipal/ManagedIdentity!");
        }
        if (this.customEntraIdAuthenticationSupplier == null && spi == null && this.mii == null) {
            throw new RedisEntraIDException("Missing configuration. One of customEntraIdAuthenticationSupplier, ServicePrincipal or ManagedIdentity must be configured!");
        }
        if (spi != null) {
            super.identityProviderConfig((IdentityProviderConfig)new EntraIDIdentityProviderConfig(spi, this.scopes, this.tokenRequestExecTimeoutInMs));
        }
        if (this.mii != null) {
            super.identityProviderConfig((IdentityProviderConfig)new EntraIDIdentityProviderConfig(this.mii, this.scopes, this.tokenRequestExecTimeoutInMs));
        }
        if (this.customEntraIdAuthenticationSupplier != null) {
            super.identityProviderConfig((IdentityProviderConfig)new EntraIDIdentityProviderConfig(this.customEntraIdAuthenticationSupplier));
        }
        return super.build();
    }

    @Override
    public void close() throws Exception {
        this.clientId = null;
        this.secret = null;
        this.key = null;
        this.cert = null;
        this.authority = null;
        this.scopes = null;
        this.customEntraIdAuthenticationSupplier = null;
    }

    public static EntraIDTokenAuthConfigBuilder builder() {
        return new EntraIDTokenAuthConfigBuilder();
    }

    public static EntraIDTokenAuthConfigBuilder from(EntraIDTokenAuthConfigBuilder sample) {
        TokenAuthConfig tokenAuthConfig = TokenAuthConfig.Builder.from((TokenAuthConfig.Builder)sample).build();
        TokenManagerConfig tokenManagerConfig = tokenAuthConfig.getTokenManagerConfig();
        EntraIDTokenAuthConfigBuilder builder = (EntraIDTokenAuthConfigBuilder)((EntraIDTokenAuthConfigBuilder)((EntraIDTokenAuthConfigBuilder)((EntraIDTokenAuthConfigBuilder)((EntraIDTokenAuthConfigBuilder)new EntraIDTokenAuthConfigBuilder().expirationRefreshRatio(tokenManagerConfig.getExpirationRefreshRatio())).lowerRefreshBoundMillis(tokenManagerConfig.getLowerRefreshBoundMillis())).tokenRequestExecTimeoutInMs(tokenManagerConfig.getTokenRequestExecTimeoutInMs()).maxAttemptsToRetry(tokenManagerConfig.getRetryPolicy().getMaxAttempts())).delayInMsToRetry(tokenManagerConfig.getRetryPolicy().getdelayInMs())).identityProviderConfig(tokenAuthConfig.getIdentityProviderConfig());
        builder.accessWith = sample.accessWith;
        builder.authority = sample.authority;
        builder.cert = sample.cert;
        builder.clientId = sample.clientId;
        builder.customEntraIdAuthenticationSupplier = sample.customEntraIdAuthenticationSupplier;
        builder.key = sample.key;
        builder.mii = sample.mii;
        builder.scopes = sample.scopes;
        builder.secret = sample.secret;
        return builder;
    }
}

