/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.authentication.entraid;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.function.BiFunction;
import redis.clients.authentication.core.Token;

public class JWToken
implements Token {
    private final String user;
    private final String token;
    private final long expiresAt;
    private final long receivedAt;
    private final BiFunction<String, Class<?>, ?> claimQuery;

    public JWToken(String token) {
        this.token = token;
        DecodedJWT jwt = JWT.decode((String)token);
        this.user = jwt.getClaim("oid").asString();
        this.expiresAt = jwt.getExpiresAt().getTime();
        this.receivedAt = System.currentTimeMillis();
        this.claimQuery = (key, clazz) -> jwt.getClaim(key).as(clazz);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiresAt;
    }

    public long ttl() {
        return this.expiresAt - System.currentTimeMillis();
    }

    public String getUser() {
        return this.user;
    }

    public String getValue() {
        return this.token;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public long getReceivedAt() {
        return this.receivedAt;
    }

    public String toString() {
        return this.token;
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (that instanceof Token) {
            return this.token.equals(((Token)that).getValue());
        }
        return this.token.equals(that);
    }

    public <T> T tryGet(String key, Class<T> clazz) {
        return (T)this.claimQuery.apply(key, clazz);
    }
}

