/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.JedisException;
import redis.clients.jedis.Protocol;
import redis.clients.util.RedisInputStream;
import redis.clients.util.RedisOutputStream;

public class Connection {
    private String host;
    private int port = 6379;
    private Socket socket;
    private Protocol protocol = new Protocol();
    private RedisOutputStream outputStream;
    private RedisInputStream inputStream;
    private int pipelinedCommands = 0;
    private int timeout = 2000;

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTimeoutInfinite() {
        try {
            this.socket.setSoTimeout(0);
        }
        catch (SocketException ex) {
            throw new JedisException(ex);
        }
    }

    public void rollbackTimeout() {
        try {
            this.socket.setSoTimeout(this.timeout);
        }
        catch (SocketException ex) {
            throw new JedisException(ex);
        }
    }

    public Connection(String host) {
        this.host = host;
    }

    protected Connection sendCommand(String name, String ... args) {
        try {
            this.connect();
        }
        catch (UnknownHostException e) {
            throw new JedisException("Could not connect to redis-server", e);
        }
        catch (IOException e) {
            throw new JedisException("Could not connect to redis-server", e);
        }
        this.protocol.sendCommand(this.outputStream, name, args);
        ++this.pipelinedCommands;
        return this;
    }

    public Connection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Connection() {
    }

    public void connect() throws UnknownHostException, IOException {
        if (!this.isConnected()) {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(this.timeout);
            this.outputStream = new RedisOutputStream(this.socket.getOutputStream());
            this.inputStream = new RedisInputStream(this.socket.getInputStream());
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.inputStream.close();
                this.outputStream.close();
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException ex) {
                throw new JedisException(ex);
            }
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    protected String getStatusCodeReply() {
        --this.pipelinedCommands;
        return (String)this.protocol.read(this.inputStream);
    }

    public String getBulkReply() {
        --this.pipelinedCommands;
        return (String)this.protocol.read(this.inputStream);
    }

    public int getIntegerReply() {
        --this.pipelinedCommands;
        return (Integer)this.protocol.read(this.inputStream);
    }

    public List<String> getMultiBulkReply() {
        --this.pipelinedCommands;
        return (List)this.protocol.read(this.inputStream);
    }

    public List<Object> getObjectMultiBulkReply() {
        --this.pipelinedCommands;
        return (List)this.protocol.read(this.inputStream);
    }

    public List<Object> getAll() {
        ArrayList<Object> all = new ArrayList<Object>();
        while (this.pipelinedCommands > 0) {
            all.add(this.protocol.read(this.inputStream));
            --this.pipelinedCommands;
        }
        return all;
    }
}

