/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import redis.clients.util.Hashing;
import redis.clients.util.ShardInfo;

public class Sharded<R, S extends ShardInfo<R>> {
    public static final int DEFAULT_WEIGHT = 1;
    private TreeMap<Long, S> nodes;
    private final Hashing algo;
    private Pattern tagPattern = null;
    public static final Pattern DEFAULT_KEY_TAG_PATTERN = Pattern.compile("\\{(.+?)\\}");

    public Sharded(List<S> shards) {
        this(shards, Hashing.MURMUR_HASH);
    }

    public Sharded(List<S> shards, Hashing algo) {
        this.algo = algo;
        this.initialize(shards);
    }

    public Sharded(List<S> shards, Pattern tagPattern) {
        this(shards, Hashing.MURMUR_HASH, tagPattern);
    }

    public Sharded(List<S> shards, Hashing algo, Pattern tagPattern) {
        this.algo = algo;
        this.tagPattern = tagPattern;
        this.initialize(shards);
    }

    private void initialize(List<S> shards) {
        this.nodes = new TreeMap();
        int totalWeight = 0;
        for (ShardInfo shard : shards) {
            totalWeight += shard.getWeight();
        }
        long oneForthOfStep = 0x4000000000000000L / (long)totalWeight;
        long floor = Long.MIN_VALUE;
        for (int i = 0; i != shards.size(); ++i) {
            ShardInfo shardInfo = (ShardInfo)shards.get(i);
            shardInfo.initResource();
            this.nodes.put(floor, shardInfo);
            floor += 4L * oneForthOfStep * (long)shardInfo.getWeight();
        }
    }

    public R getShard(String key) {
        return (R)((ShardInfo)this.nodes.floorEntry(this.algo.hash(this.getKeyTag(key))).getValue()).getResource();
    }

    public S getShardInfo(String key) {
        return (S)((ShardInfo)this.nodes.floorEntry(this.algo.hash(this.getKeyTag(key))).getValue());
    }

    public String getKeyTag(String key) {
        Matcher m;
        if (this.tagPattern != null && (m = this.tagPattern.matcher(key)).find()) {
            return m.group(1);
        }
        return key;
    }

    public Collection<S> getAllShards() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }
}

