/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.util.Hashing;
import redis.clients.util.Sharded;

public class ShardedJedis
extends Sharded<Jedis, JedisShardInfo>
implements JedisCommands {
    public ShardedJedis(List<JedisShardInfo> shards) {
        super(shards);
    }

    public ShardedJedis(List<JedisShardInfo> shards, Hashing algo) {
        super(shards, algo);
    }

    public ShardedJedis(List<JedisShardInfo> shards, Pattern keyTagPattern) {
        super(shards, keyTagPattern);
    }

    public ShardedJedis(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        super(shards, algo, keyTagPattern);
    }

    public void disconnect() throws IOException {
        for (JedisShardInfo jedis : this.getAllShards()) {
            ((Jedis)jedis.getResource()).disconnect();
        }
    }

    protected Jedis create(JedisShardInfo shard) {
        return new Jedis(shard);
    }

    @Override
    public String set(String key, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value);
    }

    @Override
    public String get(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.get(key);
    }

    @Override
    public Integer exists(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.exists(key);
    }

    @Override
    public String type(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.type(key);
    }

    @Override
    public Integer expire(String key, int seconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expire(key, seconds);
    }

    @Override
    public Integer expireAt(String key, long unixTime) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expireAt(key, unixTime);
    }

    @Override
    public Integer ttl(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ttl(key);
    }

    @Override
    public String getSet(String key, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getSet(key, value);
    }

    @Override
    public Integer setnx(String key, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setnx(key, value);
    }

    @Override
    public String setex(String key, int seconds, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setex(key, seconds, value);
    }

    @Override
    public Integer decrBy(String key, int integer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decrBy(key, integer);
    }

    @Override
    public Integer decr(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decr(key);
    }

    @Override
    public Integer incrBy(String key, int integer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrBy(key, integer);
    }

    @Override
    public Integer incr(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incr(key);
    }

    @Override
    public Integer append(String key, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.append(key, value);
    }

    @Override
    public String substr(String key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.substr(key, start, end);
    }

    @Override
    public Integer hset(String key, String field, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hset(key, field, value);
    }

    @Override
    public String hget(String key, String field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hget(key, field);
    }

    @Override
    public Integer hsetnx(String key, String field, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hsetnx(key, field, value);
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmset(key, hash);
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmget(key, fields);
    }

    @Override
    public Integer hincrBy(String key, String field, int value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrBy(key, field, value);
    }

    @Override
    public Integer hexists(String key, String field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hexists(key, field);
    }

    @Override
    public Integer hdel(String key, String field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hdel(key, field);
    }

    @Override
    public Integer hlen(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hlen(key);
    }

    @Override
    public List<String> hkeys(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hkeys(key);
    }

    @Override
    public List<String> hvals(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hvals(key);
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hgetAll(key);
    }

    @Override
    public Integer rpush(String key, String string) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpush(key, string);
    }

    @Override
    public Integer lpush(String key, String string) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpush(key, string);
    }

    @Override
    public Integer llen(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.llen(key);
    }

    @Override
    public List<String> lrange(String key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrange(key, start, end);
    }

    @Override
    public String ltrim(String key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ltrim(key, start, end);
    }

    @Override
    public String lindex(String key, int index) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lindex(key, index);
    }

    @Override
    public String lset(String key, int index, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lset(key, index, value);
    }

    @Override
    public Integer lrem(String key, int count, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrem(key, count, value);
    }

    @Override
    public String lpop(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpop(key);
    }

    @Override
    public String rpop(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpop(key);
    }

    @Override
    public Integer sadd(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sadd(key, member);
    }

    @Override
    public Set<String> smembers(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.smembers(key);
    }

    @Override
    public Integer srem(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srem(key, member);
    }

    @Override
    public String spop(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key);
    }

    @Override
    public Integer scard(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.scard(key);
    }

    @Override
    public Integer sismember(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sismember(key, member);
    }

    @Override
    public String srandmember(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key);
    }

    @Override
    public Integer zadd(String key, double score, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member);
    }

    @Override
    public Set<String> zrange(String key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrange(key, start, end);
    }

    @Override
    public Integer zrem(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrem(key, member);
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, score, member);
    }

    @Override
    public Integer zrank(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrank(key, member);
    }

    @Override
    public Integer zrevrank(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrank(key, member);
    }

    @Override
    public Set<String> zrevrange(String key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrange(key, start, end);
    }

    @Override
    public Set<Tuple> zrangeWithScores(String key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeWithScores(key, start, end);
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(String key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeWithScores(key, start, end);
    }

    @Override
    public Integer zcard(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcard(key);
    }

    @Override
    public Double zscore(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscore(key, member);
    }

    @Override
    public List<String> sort(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key);
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key, sortingParameters);
    }

    @Override
    public Integer zcount(String key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min, max);
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max);
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Integer zremrangeByRank(String key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByRank(key, start, end);
    }

    @Override
    public Integer zremrangeByScore(String key, double start, double end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, start, end);
    }

    @Override
    public Integer linsert(String key, Client.LIST_POSITION where, String pivot, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.linsert(key, where, pivot, value);
    }
}

