/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;

public class Client
extends BinaryClient {
    public Client(String host) {
        super(host);
    }

    public Client(String host, int port) {
        super(host, port);
    }

    public void set(String key, String value) {
        this.set(key.getBytes(Protocol.UTF8), value.getBytes(Protocol.UTF8));
    }

    public void get(String key) {
        this.get(key.getBytes(Protocol.UTF8));
    }

    public void exists(String key) {
        this.exists(key.getBytes(Protocol.UTF8));
    }

    public void del(String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < keys.length; ++i) {
            bkeys[i] = keys[i].getBytes(Protocol.UTF8);
        }
        this.del(bkeys);
    }

    public void type(String key) {
        this.type(key.getBytes(Protocol.UTF8));
    }

    public void keys(String pattern) {
        this.keys(pattern.getBytes(Protocol.UTF8));
    }

    public void rename(String oldkey, String newkey) {
        this.rename(oldkey.getBytes(Protocol.UTF8), newkey.getBytes(Protocol.UTF8));
    }

    public void renamenx(String oldkey, String newkey) {
        this.renamenx(oldkey.getBytes(Protocol.UTF8), newkey.getBytes(Protocol.UTF8));
    }

    public void expire(String key, int seconds) {
        this.expire(key.getBytes(Protocol.UTF8), seconds);
    }

    public void expireAt(String key, long unixTime) {
        this.expireAt(key.getBytes(Protocol.UTF8), unixTime);
    }

    public void ttl(String key) {
        this.ttl(key.getBytes(Protocol.UTF8));
    }

    public void move(String key, int dbIndex) {
        this.move(key.getBytes(Protocol.UTF8), dbIndex);
    }

    public void getSet(String key, String value) {
        this.getSet(key.getBytes(Protocol.UTF8), value.getBytes(Protocol.UTF8));
    }

    public void mget(String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = keys[i].getBytes(Protocol.UTF8);
        }
        this.mget(bkeys);
    }

    public void setnx(String key, String value) {
        this.setnx(key.getBytes(Protocol.UTF8), value.getBytes(Protocol.UTF8));
    }

    public void setex(String key, int seconds, String value) {
        this.setex(key.getBytes(Protocol.UTF8), seconds, value.getBytes(Protocol.UTF8));
    }

    public void mset(String ... keysvalues) {
        byte[][] bkeysvalues = new byte[keysvalues.length][];
        for (int i = 0; i < keysvalues.length; ++i) {
            bkeysvalues[i] = keysvalues[i].getBytes(Protocol.UTF8);
        }
        this.mset(bkeysvalues);
    }

    public void msetnx(String ... keysvalues) {
        byte[][] bkeysvalues = new byte[keysvalues.length][];
        for (int i = 0; i < keysvalues.length; ++i) {
            bkeysvalues[i] = keysvalues[i].getBytes(Protocol.UTF8);
        }
        this.msetnx(bkeysvalues);
    }

    public void decrBy(String key, int integer) {
        this.decrBy(key.getBytes(Protocol.UTF8), integer);
    }

    public void decr(String key) {
        this.decr(key.getBytes(Protocol.UTF8));
    }

    public void incrBy(String key, int integer) {
        this.incrBy(key.getBytes(Protocol.UTF8), integer);
    }

    public void incr(String key) {
        this.incr(key.getBytes(Protocol.UTF8));
    }

    public void append(String key, String value) {
        this.append(key.getBytes(Protocol.UTF8), value.getBytes(Protocol.UTF8));
    }

    public void substr(String key, int start, int end) {
        this.substr(key.getBytes(Protocol.UTF8), start, end);
    }

    public void hset(String key, String field, String value) {
        this.hset(key.getBytes(Protocol.UTF8), field.getBytes(Protocol.UTF8), value.getBytes(Protocol.UTF8));
    }

    public void hget(String key, String field) {
        this.hget(key.getBytes(Protocol.UTF8), field.getBytes(Protocol.UTF8));
    }

    public void hsetnx(String key, String field, String value) {
        this.hsetnx(key.getBytes(Protocol.UTF8), field.getBytes(Protocol.UTF8), value.getBytes(Protocol.UTF8));
    }

    public void hmset(String key, Map<String, String> hash) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(hash.size());
        for (Map.Entry<String, String> entry : hash.entrySet()) {
            bhash.put(entry.getKey().getBytes(Protocol.UTF8), entry.getValue().getBytes(Protocol.UTF8));
        }
        this.hmset(key.getBytes(Protocol.UTF8), bhash);
    }

    public void hmget(String key, String ... fields) {
        byte[][] bfields = new byte[fields.length][];
        for (int i = 0; i < bfields.length; ++i) {
            bfields[i] = fields[i].getBytes(Protocol.UTF8);
        }
        this.hmget(key.getBytes(Protocol.UTF8), bfields);
    }

    public void hincrBy(String key, String field, int value) {
        this.hincrBy(key.getBytes(Protocol.UTF8), field.getBytes(Protocol.UTF8), value);
    }

    public void hexists(String key, String field) {
        this.hexists(key.getBytes(Protocol.UTF8), field.getBytes(Protocol.UTF8));
    }

    public void hdel(String key, String field) {
        this.hdel(key.getBytes(Protocol.UTF8), field.getBytes(Protocol.UTF8));
    }

    public void hlen(String key) {
        this.hlen(key.getBytes(Protocol.UTF8));
    }

    public void hkeys(String key) {
        this.hkeys(key.getBytes(Protocol.UTF8));
    }

    public void hvals(String key) {
        this.hvals(key.getBytes(Protocol.UTF8));
    }

    public void hgetAll(String key) {
        this.hgetAll(key.getBytes(Protocol.UTF8));
    }

    public void rpush(String key, String string) {
        this.rpush(key.getBytes(Protocol.UTF8), string.getBytes(Protocol.UTF8));
    }

    public void lpush(String key, String string) {
        this.lpush(key.getBytes(Protocol.UTF8), string.getBytes(Protocol.UTF8));
    }

    public void llen(String key) {
        this.llen(key.getBytes(Protocol.UTF8));
    }

    public void lrange(String key, int start, int end) {
        this.lrange(key.getBytes(Protocol.UTF8), start, end);
    }

    public void ltrim(String key, int start, int end) {
        this.ltrim(key.getBytes(Protocol.UTF8), start, end);
    }

    public void lindex(String key, int index) {
        this.lindex(key.getBytes(Protocol.UTF8), index);
    }

    public void lset(String key, int index, String value) {
        this.lset(key.getBytes(Protocol.UTF8), index, value.getBytes(Protocol.UTF8));
    }

    public void lrem(String key, int count, String value) {
        this.lrem(key.getBytes(Protocol.UTF8), count, value.getBytes(Protocol.UTF8));
    }

    public void lpop(String key) {
        this.lpop(key.getBytes(Protocol.UTF8));
    }

    public void rpop(String key) {
        this.rpop(key.getBytes(Protocol.UTF8));
    }

    public void rpoplpush(String srckey, String dstkey) {
        this.rpoplpush(srckey.getBytes(Protocol.UTF8), dstkey.getBytes(Protocol.UTF8));
    }

    public void sadd(String key, String member) {
        this.sadd(key.getBytes(Protocol.UTF8), member.getBytes(Protocol.UTF8));
    }

    public void smembers(String key) {
        this.smembers(key.getBytes(Protocol.UTF8));
    }

    public void srem(String key, String member) {
        this.srem(key.getBytes(Protocol.UTF8), member.getBytes(Protocol.UTF8));
    }

    public void spop(String key) {
        this.spop(key.getBytes(Protocol.UTF8));
    }

    public void smove(String srckey, String dstkey, String member) {
        this.smove(srckey.getBytes(Protocol.UTF8), dstkey.getBytes(Protocol.UTF8), member.getBytes(Protocol.UTF8));
    }

    public void scard(String key) {
        this.scard(key.getBytes(Protocol.UTF8));
    }

    public void sismember(String key, String member) {
        this.sismember(key.getBytes(Protocol.UTF8), member.getBytes(Protocol.UTF8));
    }

    public void sinter(String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = keys[i].getBytes(Protocol.UTF8);
        }
        this.sinter(bkeys);
    }

    public void sinterstore(String dstkey, String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = keys[i].getBytes(Protocol.UTF8);
        }
        this.sinterstore(dstkey.getBytes(Protocol.UTF8), bkeys);
    }

    public void sunion(String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = keys[i].getBytes(Protocol.UTF8);
        }
        this.sunion(bkeys);
    }

    public void sunionstore(String dstkey, String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = keys[i].getBytes(Protocol.UTF8);
        }
        this.sunionstore(dstkey.getBytes(Protocol.UTF8), bkeys);
    }

    public void sdiff(String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = keys[i].getBytes(Protocol.UTF8);
        }
        this.sdiff(bkeys);
    }

    public void sdiffstore(String dstkey, String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = keys[i].getBytes(Protocol.UTF8);
        }
        this.sdiffstore(dstkey.getBytes(Protocol.UTF8), bkeys);
    }

    public void srandmember(String key) {
        this.srandmember(key.getBytes(Protocol.UTF8));
    }

    public void zadd(String key, double score, String member) {
        this.zadd(key.getBytes(Protocol.UTF8), score, member.getBytes(Protocol.UTF8));
    }

    public void zrange(String key, int start, int end) {
        this.zrange(key.getBytes(Protocol.UTF8), start, end);
    }

    public void zrem(String key, String member) {
        this.zrem(key.getBytes(Protocol.UTF8), member.getBytes(Protocol.UTF8));
    }

    public void zincrby(String key, double score, String member) {
        this.zincrby(key.getBytes(Protocol.UTF8), score, member.getBytes(Protocol.UTF8));
    }

    public void zrank(String key, String member) {
        this.zrank(key.getBytes(Protocol.UTF8), member.getBytes(Protocol.UTF8));
    }

    public void zrevrank(String key, String member) {
        this.zrevrank(key.getBytes(Protocol.UTF8), member.getBytes(Protocol.UTF8));
    }

    public void zrevrange(String key, int start, int end) {
        this.zrevrange(key.getBytes(Protocol.UTF8), start, end);
    }

    public void zrangeWithScores(String key, int start, int end) {
        this.zrangeWithScores(key.getBytes(Protocol.UTF8), start, end);
    }

    public void zrevrangeWithScores(String key, int start, int end) {
        this.zrevrangeWithScores(key.getBytes(Protocol.UTF8), start, end);
    }

    public void zcard(String key) {
        this.zcard(key.getBytes(Protocol.UTF8));
    }

    public void zscore(String key, String member) {
        this.zscore(key.getBytes(Protocol.UTF8), member.getBytes(Protocol.UTF8));
    }

    public void watch(String key) {
        this.watch(key.getBytes(Protocol.UTF8));
    }

    public void sort(String key) {
        this.sort(key.getBytes(Protocol.UTF8));
    }

    public void sort(String key, SortingParams sortingParameters) {
        this.sort(key.getBytes(Protocol.UTF8), sortingParameters);
    }

    public void blpop(String[] args) {
        byte[][] bargs = new byte[args.length][];
        for (int i = 0; i < bargs.length; ++i) {
            bargs[i] = args[i].getBytes(Protocol.UTF8);
        }
        this.blpop(bargs);
    }

    public void sort(String key, SortingParams sortingParameters, String dstkey) {
        this.sort(key.getBytes(Protocol.UTF8), sortingParameters, dstkey.getBytes(Protocol.UTF8));
    }

    public void sort(String key, String dstkey) {
        this.sort(key.getBytes(Protocol.UTF8), dstkey.getBytes(Protocol.UTF8));
    }

    public void brpop(String[] args) {
        byte[][] bargs = new byte[args.length][];
        for (int i = 0; i < bargs.length; ++i) {
            bargs[i] = args[i].getBytes(Protocol.UTF8);
        }
        this.brpop(bargs);
    }

    public void zcount(String key, double min, double max) {
        this.zcount(key.getBytes(Protocol.UTF8), min, max);
    }

    public void zrangeByScore(String key, double min, double max) {
        this.zrangeByScore(key.getBytes(Protocol.UTF8), min, max);
    }

    public void zrangeByScore(String key, String min, String max) {
        this.zrangeByScore(key.getBytes(Protocol.UTF8), min.getBytes(Protocol.UTF8), max.getBytes(Protocol.UTF8));
    }

    public void zrangeByScore(String key, double min, double max, int offset, int count) {
        this.zrangeByScore(key.getBytes(Protocol.UTF8), min, max, offset, count);
    }

    public void zrangeByScoreWithScores(String key, double min, double max) {
        this.zrangeByScoreWithScores(key.getBytes(Protocol.UTF8), min, max);
    }

    public void zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.zrangeByScoreWithScores(key.getBytes(Protocol.UTF8), min, max, offset, count);
    }

    public void zremrangeByRank(String key, int start, int end) {
        this.zremrangeByRank(key.getBytes(Protocol.UTF8), start, end);
    }

    public void zremrangeByScore(String key, double start, double end) {
        this.zremrangeByScore(key.getBytes(Protocol.UTF8), start, end);
    }

    public void zunionstore(String dstkey, String ... sets) {
        byte[][] bsets = new byte[sets.length][];
        for (int i = 0; i < bsets.length; ++i) {
            bsets[i] = sets[i].getBytes(Protocol.UTF8);
        }
        this.zunionstore(dstkey.getBytes(Protocol.UTF8), bsets);
    }

    public void zunionstore(String dstkey, ZParams params, String ... sets) {
        byte[][] bsets = new byte[sets.length][];
        for (int i = 0; i < bsets.length; ++i) {
            bsets[i] = sets[i].getBytes(Protocol.UTF8);
        }
        this.zunionstore(dstkey.getBytes(Protocol.UTF8), params, (byte[][])bsets);
    }

    public void zinterstore(String dstkey, String ... sets) {
        byte[][] bsets = new byte[sets.length][];
        for (int i = 0; i < bsets.length; ++i) {
            bsets[i] = sets[i].getBytes(Protocol.UTF8);
        }
        this.zinterstore(dstkey.getBytes(Protocol.UTF8), bsets);
    }

    public void zinterstore(String dstkey, ZParams params, String ... sets) {
        byte[][] bsets = new byte[sets.length][];
        for (int i = 0; i < bsets.length; ++i) {
            bsets[i] = sets[i].getBytes(Protocol.UTF8);
        }
        this.zinterstore(dstkey.getBytes(Protocol.UTF8), params, (byte[][])bsets);
    }

    public void strlen(String key) {
        this.strlen(key.getBytes(Protocol.UTF8));
    }

    public void lpushx(String key, String string) {
        this.lpushx(key.getBytes(Protocol.UTF8), string.getBytes(Protocol.UTF8));
    }

    public void persist(String key) {
        this.persist(key.getBytes(Protocol.UTF8));
    }

    public void rpushx(String key, String string) {
        this.rpushx(key.getBytes(Protocol.UTF8), string.getBytes(Protocol.UTF8));
    }

    public void echo(String string) {
        this.echo(string.getBytes(Protocol.UTF8));
    }

    public void linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        this.linsert(key.getBytes(Protocol.UTF8), where, pivot.getBytes(Protocol.UTF8), value.getBytes(Protocol.UTF8));
    }
}

