/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.JedisException;
import redis.clients.util.RedisInputStream;
import redis.clients.util.RedisOutputStream;

public final class Protocol {
    public static final int DEFAULT_PORT = 6379;
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final byte DOLLAR_BYTE = 36;
    public static final byte ASTERISK_BYTE = 42;
    public static final byte PLUS_BYTE = 43;
    public static final byte MINUS_BYTE = 45;
    public static final byte COLON_BYTE = 58;

    public void sendCommand(RedisOutputStream os, Command command, byte[] ... args) {
        this.sendCommand(os, command.raw, args);
    }

    private void sendCommand(RedisOutputStream os, byte[] command, byte[] ... args) {
        try {
            os.write((byte)42);
            os.writeIntCrLf(args.length + 1);
            os.write((byte)36);
            os.writeIntCrLf(command.length);
            os.write(command);
            os.writeCrLf();
            for (byte[] arg : args) {
                os.write((byte)36);
                os.writeIntCrLf(arg.length);
                os.write(arg);
                os.writeCrLf();
            }
            os.flush();
        }
        catch (IOException e) {
            throw new JedisException(e);
        }
    }

    private void processError(RedisInputStream is) {
        String message = is.readLine();
        throw new JedisException(message);
    }

    private Object process(RedisInputStream is) {
        try {
            byte b = is.readByte();
            if (b != 45) {
                if (b == 42) {
                    return this.processMultiBulkReply(is);
                }
                if (b == 58) {
                    return this.processInteger(is);
                }
                if (b == 36) {
                    return this.processBulkReply(is);
                }
                if (b == 43) {
                    return this.processStatusCodeReply(is);
                }
                throw new JedisException("Unknown reply: " + (char)b);
            }
            this.processError(is);
        }
        catch (IOException e) {
            throw new JedisException(e);
        }
        return null;
    }

    private byte[] processStatusCodeReply(RedisInputStream is) {
        return is.readLine().getBytes(UTF8);
    }

    private byte[] processBulkReply(RedisInputStream is) {
        int len = Integer.parseInt(is.readLine());
        if (len == -1) {
            return null;
        }
        byte[] read = new byte[len];
        try {
            for (int offset = 0; offset < len; offset += is.read(read, offset, len - offset)) {
            }
            is.readByte();
            is.readByte();
        }
        catch (IOException e) {
            throw new JedisException(e);
        }
        return read;
    }

    private Integer processInteger(RedisInputStream is) {
        String num = is.readLine();
        return Integer.valueOf(num);
    }

    private List<Object> processMultiBulkReply(RedisInputStream is) {
        int num = Integer.parseInt(is.readLine());
        if (num == -1) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>(num);
        for (int i = 0; i < num; ++i) {
            ret.add(this.process(is));
        }
        return ret;
    }

    public Object read(RedisInputStream is) {
        return this.process(is);
    }

    public static final byte[] toByteArray(int value) {
        return String.valueOf(value).getBytes(UTF8);
    }

    public static final byte[] toByteArray(long value) {
        return String.valueOf(value).getBytes(UTF8);
    }

    public static final byte[] toByteArray(double value) {
        return String.valueOf(value).getBytes(UTF8);
    }

    public static enum Keyword {
        AGGREGATE,
        ALPHA,
        ASC,
        BY,
        DESC,
        GET,
        LIMIT,
        MESSAGE,
        NO,
        NOSORT,
        PMESSAGE,
        PSUBSCRIBE,
        PUNSUBSCRIBE,
        OK,
        ONE,
        QUEUED,
        SET,
        STORE,
        SUBSCRIBE,
        UNSUBSCRIBE,
        WEIGHTS,
        WITHSCORES;

        public final byte[] raw = this.name().toLowerCase().getBytes(UTF8);
    }

    public static enum Command {
        PING,
        SET,
        GET,
        QUIT,
        EXISTS,
        DEL,
        TYPE,
        FLUSHDB,
        KEYS,
        RANDOMKEY,
        RENAME,
        RENAMENX,
        RENAMEX,
        DBSIZE,
        EXPIRE,
        EXPIREAT,
        TTL,
        SELECT,
        MOVE,
        FLUSHALL,
        GETSET,
        MGET,
        SETNX,
        SETEX,
        MSET,
        MSETNX,
        DECRBY,
        DECR,
        INCRBY,
        INCR,
        APPEND,
        SUBSTR,
        HSET,
        HGET,
        HSETNX,
        HMSET,
        HMGET,
        HINCRBY,
        HEXISTS,
        HDEL,
        HLEN,
        HKEYS,
        HVALS,
        HGETALL,
        RPUSH,
        LPUSH,
        LLEN,
        LRANGE,
        LTRIM,
        LINDEX,
        LSET,
        LREM,
        LPOP,
        RPOP,
        RPOPLPUSH,
        SADD,
        SMEMBERS,
        SREM,
        SPOP,
        SMOVE,
        SCARD,
        SISMEMBER,
        SINTER,
        SINTERSTORE,
        SUNION,
        SUNIONSTORE,
        SDIFF,
        SDIFFSTORE,
        SRANDMEMBER,
        ZADD,
        ZRANGE,
        ZREM,
        ZINCRBY,
        ZRANK,
        ZREVRANK,
        ZREVRANGE,
        ZCARD,
        ZSCORE,
        MULTI,
        DISCARD,
        EXEC,
        WATCH,
        UNWATCH,
        SORT,
        BLPOP,
        BRPOP,
        AUTH,
        SUBSCRIBE,
        PUBLISH,
        UNSUBSCRIBE,
        PSUBSCRIBE,
        PUNSUBSCRIBE,
        ZCOUNT,
        ZRANGEBYSCORE,
        ZREMRANGEBYRANK,
        ZREMRANGEBYSCORE,
        ZUNIONSTORE,
        ZINTERSTORE,
        SAVE,
        BGSAVE,
        BGREWRITEAOF,
        LASTSAVE,
        SHUTDOWN,
        INFO,
        MONITOR,
        SLAVEOF,
        CONFIG,
        STRLEN,
        SYNC,
        LPUSHX,
        PERSIST,
        RPUSHX,
        ECHO,
        LINSERT,
        DEBUG;

        public final byte[] raw = this.name().getBytes(UTF8);
    }
}

