/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.util.Hashing;
import redis.clients.util.Sharded;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryShardedJedis
extends Sharded<Jedis, JedisShardInfo>
implements BinaryJedisCommands {
    public BinaryShardedJedis(List<JedisShardInfo> shards) {
        super(shards);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Hashing algo) {
        super(shards, algo);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Pattern keyTagPattern) {
        super(shards, keyTagPattern);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        super(shards, algo, keyTagPattern);
    }

    public void disconnect() throws IOException {
        for (Jedis jedis : this.getAllShards()) {
            jedis.disconnect();
        }
    }

    protected Jedis create(JedisShardInfo shard) {
        return new Jedis(shard);
    }

    @Override
    public String set(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value);
    }

    @Override
    public byte[] get(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.get(key);
    }

    @Override
    public Boolean exists(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.exists(key);
    }

    @Override
    public String type(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.type(key);
    }

    @Override
    public Long expire(byte[] key, int seconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expire(key, seconds);
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expireAt(key, unixTime);
    }

    @Override
    public Long ttl(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ttl(key);
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getSet(key, value);
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setnx(key, value);
    }

    @Override
    public String setex(byte[] key, int seconds, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setex(key, seconds, value);
    }

    @Override
    public Long decrBy(byte[] key, int integer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decrBy(key, integer);
    }

    @Override
    public Long decr(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decr(key);
    }

    @Override
    public Long incrBy(byte[] key, int integer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrBy(key, integer);
    }

    @Override
    public Long incr(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incr(key);
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.append(key, value);
    }

    @Override
    public byte[] substr(byte[] key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.substr(key, start, end);
    }

    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hset(key, field, value);
    }

    @Override
    public byte[] hget(byte[] key, byte[] field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hget(key, field);
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hsetnx(key, field, value);
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmset(key, hash);
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmget(key, fields);
    }

    @Override
    public Long hincrBy(byte[] key, byte[] field, int value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrBy(key, field, value);
    }

    @Override
    public Boolean hexists(byte[] key, byte[] field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hexists(key, field);
    }

    @Override
    public Long hdel(byte[] key, byte[] field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hdel(key, field);
    }

    @Override
    public Long hlen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hlen(key);
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hkeys(key);
    }

    @Override
    public Collection<byte[]> hvals(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hvals(key);
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hgetAll(key);
    }

    @Override
    public Long rpush(byte[] key, byte[] string) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpush(key, string);
    }

    @Override
    public Long lpush(byte[] key, byte[] string) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpush(key, string);
    }

    @Override
    public Long llen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.llen(key);
    }

    @Override
    public List<byte[]> lrange(byte[] key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrange(key, start, end);
    }

    @Override
    public String ltrim(byte[] key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ltrim(key, start, end);
    }

    @Override
    public byte[] lindex(byte[] key, int index) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lindex(key, index);
    }

    @Override
    public String lset(byte[] key, int index, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lset(key, index, value);
    }

    @Override
    public Long lrem(byte[] key, int count, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrem(key, count, value);
    }

    @Override
    public byte[] lpop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpop(key);
    }

    @Override
    public byte[] rpop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpop(key);
    }

    @Override
    public Long sadd(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sadd(key, member);
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.smembers(key);
    }

    @Override
    public Long srem(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srem(key, member);
    }

    @Override
    public byte[] spop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key);
    }

    @Override
    public Long scard(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.scard(key);
    }

    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sismember(key, member);
    }

    @Override
    public byte[] srandmember(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member);
    }

    @Override
    public Set<byte[]> zrange(byte[] key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrange(key, start, end);
    }

    @Override
    public Long zrem(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrem(key, member);
    }

    @Override
    public Double zincrby(byte[] key, double score, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, score, member);
    }

    @Override
    public Long zrank(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrank(key, member);
    }

    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrank(key, member);
    }

    @Override
    public Set<byte[]> zrevrange(byte[] key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrange(key, start, end);
    }

    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeWithScores(key, start, end);
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeWithScores(key, start, end);
    }

    @Override
    public Long zcard(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcard(key);
    }

    @Override
    public Double zscore(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscore(key, member);
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key);
    }

    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key, sortingParameters);
    }

    @Override
    public Long zcount(byte[] key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min, max);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Long zremrangeByRank(byte[] key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByRank(key, start, end);
    }

    @Override
    public Long zremrangeByScore(byte[] key, double start, double end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, start, end);
    }

    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.linsert(key, where, pivot, value);
    }

    public List<Object> pipelined(ShardedJedisPipeline shardedJedisPipeline) {
        shardedJedisPipeline.setShardedJedis(this);
        shardedJedisPipeline.execute();
        return shardedJedisPipeline.getResults();
    }
}

