/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisException;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.TransactionBlock;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jedis
extends BinaryJedis
implements JedisCommands {
    public Jedis(String host) {
        super(host);
    }

    public Jedis(String host, int port) {
        super(host, port);
    }

    public Jedis(String host, int port, int timeout) {
        super(host, port, timeout);
    }

    public Jedis(JedisShardInfo shardInfo) {
        super(shardInfo);
    }

    @Override
    public String ping() {
        this.runChecks();
        this.client.ping();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(String key, String value) {
        this.runChecks();
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String get(String key) {
        this.runChecks();
        this.client.sendCommand(Protocol.Command.GET, key);
        return this.client.getBulkReply();
    }

    @Override
    public void quit() {
        this.runChecks();
        this.client.quit();
    }

    @Override
    public Boolean exists(String key) {
        this.runChecks();
        this.client.exists(key);
        return this.client.getIntegerReply() == 1L;
    }

    public Long del(String ... keys) {
        this.runChecks();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String type(String key) {
        this.runChecks();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String flushDB() {
        this.runChecks();
        this.client.flushDB();
        return this.client.getStatusCodeReply();
    }

    public Set<String> keys(String pattern) {
        this.runChecks();
        this.client.keys(pattern);
        HashSet<String> keySet = new HashSet<String>(this.client.getMultiBulkReply());
        return keySet;
    }

    public String randomKey() {
        this.runChecks();
        this.client.randomKey();
        return this.client.getBulkReply();
    }

    public String rename(String oldkey, String newkey) {
        this.runChecks();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    public Long renamenx(String oldkey, String newkey) {
        this.runChecks();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long dbSize() {
        this.runChecks();
        this.client.dbSize();
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(String key, int seconds) {
        this.runChecks();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        this.runChecks();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(String key) {
        this.runChecks();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String select(int index) {
        this.runChecks();
        this.client.select(index);
        return this.client.getStatusCodeReply();
    }

    public Long move(String key, int dbIndex) {
        this.runChecks();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    @Override
    public String flushAll() {
        this.runChecks();
        this.client.flushAll();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String getSet(String key, String value) {
        this.runChecks();
        this.client.getSet(key, value);
        return this.client.getBulkReply();
    }

    public List<String> mget(String ... keys) {
        this.runChecks();
        this.client.mget(keys);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long setnx(String key, String value) {
        this.runChecks();
        this.client.setnx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(String key, int seconds, String value) {
        this.runChecks();
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    public String mset(String ... keysvalues) {
        this.runChecks();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    public Long msetnx(String ... keysvalues) {
        this.runChecks();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(String key, int integer) {
        this.runChecks();
        this.client.decrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(String key) {
        this.runChecks();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(String key, int integer) {
        this.runChecks();
        this.client.incrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incr(String key) {
        this.runChecks();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(String key, String value) {
        this.runChecks();
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String substr(String key, int start, int end) {
        this.runChecks();
        this.client.substr(key, start, end);
        return this.client.getBulkReply();
    }

    @Override
    public Long hset(String key, String field, String value) {
        this.runChecks();
        this.client.hset(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hget(String key, String field) {
        this.runChecks();
        this.client.hget(key, field);
        return this.client.getBulkReply();
    }

    @Override
    public Long hsetnx(String key, String field, String value) {
        this.runChecks();
        this.client.hsetnx(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        this.runChecks();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        this.runChecks();
        this.client.hmget(key, fields);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long hincrBy(String key, String field, int value) {
        this.runChecks();
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean hexists(String key, String field) {
        this.runChecks();
        this.client.hexists(key, field);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long hdel(String key, String field) {
        this.runChecks();
        this.client.hdel(key, field);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(String key) {
        this.runChecks();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> hkeys(String key) {
        this.runChecks();
        this.client.hkeys(key);
        List<String> lresult = this.client.getMultiBulkReply();
        return new HashSet<String>(lresult);
    }

    public List<String> hvals(String key) {
        this.runChecks();
        this.client.hvals(key);
        List<String> lresult = this.client.getMultiBulkReply();
        return lresult;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        this.runChecks();
        this.client.hgetAll(key);
        List<String> flatHash = this.client.getMultiBulkReply();
        HashMap<String, String> hash = new HashMap<String, String>();
        Iterator<String> iterator = flatHash.iterator();
        while (iterator.hasNext()) {
            hash.put(iterator.next(), iterator.next());
        }
        return hash;
    }

    @Override
    public Long rpush(String key, String string) {
        this.runChecks();
        this.client.rpush(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(String key, String string) {
        this.runChecks();
        this.client.lpush(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(String key) {
        this.runChecks();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> lrange(String key, int start, int end) {
        this.runChecks();
        this.client.lrange(key, start, end);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String ltrim(String key, int start, int end) {
        this.runChecks();
        this.client.ltrim(key, start, end);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String lindex(String key, int index) {
        this.runChecks();
        this.client.lindex(key, index);
        return this.client.getBulkReply();
    }

    @Override
    public String lset(String key, int index, String value) {
        this.runChecks();
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(String key, int count, String value) {
        this.runChecks();
        this.client.lrem(key, count, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String lpop(String key) {
        this.runChecks();
        this.client.lpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public String rpop(String key) {
        this.runChecks();
        this.client.rpop(key);
        return this.client.getBulkReply();
    }

    public String rpoplpush(String srckey, String dstkey) {
        this.runChecks();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBulkReply();
    }

    @Override
    public Long sadd(String key, String member) {
        this.runChecks();
        this.client.sadd(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> smembers(String key) {
        this.runChecks();
        this.client.smembers(key);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Long srem(String key, String member) {
        this.runChecks();
        this.client.srem(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public String spop(String key) {
        this.runChecks();
        this.client.spop(key);
        return this.client.getBulkReply();
    }

    public Long smove(String srckey, String dstkey, String member) {
        this.runChecks();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(String key) {
        this.runChecks();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(String key, String member) {
        this.runChecks();
        this.client.sismember(key, member);
        return this.client.getIntegerReply() == 1L;
    }

    public Set<String> sinter(String ... keys) {
        this.runChecks();
        this.client.sinter(keys);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    public Long sinterstore(String dstkey, String ... keys) {
        this.runChecks();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    public Set<String> sunion(String ... keys) {
        this.runChecks();
        this.client.sunion(keys);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    public Long sunionstore(String dstkey, String ... keys) {
        this.runChecks();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    public Set<String> sdiff(String ... keys) {
        this.runChecks();
        this.client.sdiff(keys);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    public Long sdiffstore(String dstkey, String ... keys) {
        this.runChecks();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String srandmember(String key) {
        this.runChecks();
        this.client.srandmember(key);
        return this.client.getBulkReply();
    }

    @Override
    public Long zadd(String key, double score, String member) {
        this.runChecks();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrange(String key, int start, int end) {
        this.runChecks();
        this.client.zrange(key, start, end);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Long zrem(String key, String member) {
        this.runChecks();
        this.client.zrem(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        this.runChecks();
        this.client.zincrby(key, score, member);
        String newscore = this.client.getBulkReply();
        return Double.valueOf(newscore);
    }

    @Override
    public Long zrank(String key, String member) {
        this.runChecks();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(String key, String member) {
        this.runChecks();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrevrange(String key, int start, int end) {
        this.runChecks();
        this.client.zrevrange(key, start, end);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<Tuple> zrangeWithScores(String key, int start, int end) {
        this.runChecks();
        this.client.zrangeWithScores(key, start, end);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(String key, int start, int end) {
        this.runChecks();
        this.client.zrevrangeWithScores(key, start, end);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Long zcard(String key) {
        this.runChecks();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(String key, String member) {
        this.runChecks();
        this.client.zscore(key, member);
        String score = this.client.getBulkReply();
        return score != null ? new Double(score) : null;
    }

    @Override
    public Transaction multi() {
        this.client.multi();
        this.client.getStatusCodeReply();
        return new Transaction(this.client);
    }

    @Override
    public List<Object> multi(TransactionBlock jedisTransaction) {
        List<Object> results = null;
        try {
            jedisTransaction.setClient(this.client);
            this.multi();
            jedisTransaction.execute();
            results = jedisTransaction.exec();
        }
        catch (Exception ex) {
            this.client.discard();
        }
        return results;
    }

    private void runChecks() {
        if (this.client.isInMulti()) {
            throw new JedisException("Cannot use Jedis when in Multi. Please use JedisTransaction instead.");
        }
        try {
            this.connect();
        }
        catch (UnknownHostException e) {
            throw new JedisException(e);
        }
        catch (IOException e) {
            throw new JedisException(e);
        }
    }

    @Override
    public void connect() throws UnknownHostException, IOException {
        if (!this.client.isConnected()) {
            this.client.connect();
            if (this.password != null) {
                this.auth(this.password);
            }
        }
    }

    @Override
    public void disconnect() throws IOException {
        this.client.disconnect();
    }

    public String watch(String ... keys) {
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> sort(String key) {
        this.runChecks();
        this.client.sort(key);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        this.runChecks();
        this.client.sort(key, sortingParameters);
        return this.client.getMultiBulkReply();
    }

    public List<String> blpop(int timeout, String ... keys) {
        this.runChecks();
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : keys) {
            args.add(arg);
        }
        args.add(String.valueOf(timeout));
        this.client.blpop(args.toArray(new String[args.size()]));
        this.client.setTimeoutInfinite();
        List<String> multiBulkReply = this.client.getMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        this.runChecks();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    public Long sort(String key, String dstkey) {
        this.runChecks();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    public List<String> brpop(int timeout, String ... keys) {
        this.runChecks();
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : keys) {
            args.add(arg);
        }
        args.add(String.valueOf(timeout));
        this.client.brpop(args.toArray(new String[args.size()]));
        this.client.setTimeoutInfinite();
        List<String> multiBulkReply = this.client.getMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    @Override
    public String auth(String password) {
        this.runChecks();
        this.client.auth(password);
        return this.client.getStatusCodeReply();
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.client.setTimeoutInfinite();
        jedisPubSub.proceed(this.client, channels);
        this.client.rollbackTimeout();
    }

    @Override
    public Long publish(String channel, String message) {
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.client.setTimeoutInfinite();
        jedisPubSub.proceedWithPatterns(this.client, patterns);
        this.client.rollbackTimeout();
    }

    @Override
    public Long zcount(String key, double min, double max) {
        this.runChecks();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max) {
        this.runChecks();
        this.client.zrangeByScore(key, min, max);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        this.runChecks();
        this.client.zrangeByScore(key, min, max);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        this.runChecks();
        this.client.zrangeByScore(key, min, max, offset, count);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        this.runChecks();
        this.client.zrangeByScoreWithScores(key, min, max);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.runChecks();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    private Set<Tuple> getTupledSet() {
        this.runChecks();
        List<String> membersWithScores = this.client.getMultiBulkReply();
        LinkedHashSet<Tuple> set = new LinkedHashSet<Tuple>();
        Iterator<String> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            set.add(new Tuple(iterator.next(), Double.valueOf(iterator.next())));
        }
        return set;
    }

    @Override
    public Long zremrangeByRank(String key, int start, int end) {
        this.runChecks();
        this.client.zremrangeByRank(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, double start, double end) {
        this.runChecks();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    public Long zunionstore(String dstkey, String ... sets) {
        this.runChecks();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        this.runChecks();
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    public Long zinterstore(String dstkey, String ... sets) {
        this.runChecks();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        this.runChecks();
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    public Long strlen(String key) {
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    public Long lpushx(String key, String string) {
        this.client.lpushx(key, string);
        return this.client.getIntegerReply();
    }

    public Long persist(String key) {
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    public Long rpushx(String key, String string) {
        this.client.rpushx(key, string);
        return this.client.getIntegerReply();
    }

    public String echo(String string) {
        this.client.echo(string);
        return this.client.getBulkReply();
    }

    @Override
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }
}

