/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryShardedJedis;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.SortingParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShardedJedisPipeline {
    private BinaryShardedJedis jedis;
    private List<FutureResult> results = new ArrayList<FutureResult>();

    public void setShardedJedis(BinaryShardedJedis jedis) {
        this.jedis = jedis;
    }

    protected void set(String key, String value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.set(key, value);
        this.results.add(new FutureResult(c));
    }

    protected void get(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.get(key);
        this.results.add(new FutureResult(c));
    }

    protected void exists(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.exists(key);
        this.results.add(new FutureResult(c));
    }

    protected void type(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.type(key);
        this.results.add(new FutureResult(c));
    }

    protected void expire(String key, int seconds) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.expire(key, seconds);
        this.results.add(new FutureResult(c));
    }

    protected void expireAt(String key, long unixTime) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.expireAt(key, unixTime);
        this.results.add(new FutureResult(c));
    }

    protected void ttl(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.ttl(key);
        this.results.add(new FutureResult(c));
    }

    protected void getSet(String key, String value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.getSet(key, value);
        this.results.add(new FutureResult(c));
    }

    protected void setnx(String key, String value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.setnx(key, value);
        this.results.add(new FutureResult(c));
    }

    protected void setex(String key, int seconds, String value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.setex(key, seconds, value);
        this.results.add(new FutureResult(c));
    }

    protected void decrBy(String key, int integer) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.decrBy(key, integer);
        this.results.add(new FutureResult(c));
    }

    protected void decr(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.decr(key);
        this.results.add(new FutureResult(c));
    }

    protected void incrBy(String key, int integer) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.incrBy(key, integer);
        this.results.add(new FutureResult(c));
    }

    protected void incr(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.incr(key);
        this.results.add(new FutureResult(c));
    }

    protected void append(String key, String value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.append(key, value);
        this.results.add(new FutureResult(c));
    }

    protected void substr(String key, int start, int end) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.substr(key, start, end);
        this.results.add(new FutureResult(c));
    }

    protected void hset(String key, String field, String value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hset(key, field, value);
        this.results.add(new FutureResult(c));
    }

    protected void hget(String key, String field) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hget(key, field);
        this.results.add(new FutureResult(c));
    }

    protected void hsetnx(String key, String field, String value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hsetnx(key, field, value);
        this.results.add(new FutureResult(c));
    }

    protected void hmset(String key, Map<String, String> hash) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hmset(key, hash);
        this.results.add(new FutureResult(c));
    }

    protected void hmget(String key, String ... fields) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hmget(key, fields);
        this.results.add(new FutureResult(c));
    }

    protected void hincrBy(String key, String field, int value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hincrBy(key, field, value);
        this.results.add(new FutureResult(c));
    }

    protected void hexists(String key, String field) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hexists(key, field);
        this.results.add(new FutureResult(c));
    }

    protected void hdel(String key, String field) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hdel(key, field);
        this.results.add(new FutureResult(c));
    }

    protected void hlen(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hlen(key);
        this.results.add(new FutureResult(c));
    }

    protected void hkeys(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hkeys(key);
        this.results.add(new FutureResult(c));
    }

    protected void hvals(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hvals(key);
        this.results.add(new FutureResult(c));
    }

    protected void hgetAll(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.hgetAll(key);
        this.results.add(new FutureResult(c));
    }

    protected void rpush(String key, String string) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.rpush(key, string);
        this.results.add(new FutureResult(c));
    }

    protected void lpush(String key, String string) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.lpush(key, string);
        this.results.add(new FutureResult(c));
    }

    protected void llen(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.llen(key);
        this.results.add(new FutureResult(c));
    }

    protected void lrange(String key, int start, int end) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.lrange(key, start, end);
        this.results.add(new FutureResult(c));
    }

    protected void ltrim(String key, int start, int end) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.ltrim(key, start, end);
        this.results.add(new FutureResult(c));
    }

    protected void lindex(String key, int index) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.lindex(key, index);
        this.results.add(new FutureResult(c));
    }

    protected void lset(String key, int index, String value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.lset(key, index, value);
        this.results.add(new FutureResult(c));
    }

    protected void lrem(String key, int count, String value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.lrem(key, count, value);
        this.results.add(new FutureResult(c));
    }

    protected void lpop(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.lpop(key);
        this.results.add(new FutureResult(c));
    }

    protected void rpop(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.rpop(key);
        this.results.add(new FutureResult(c));
    }

    protected void sadd(String key, String member) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.sadd(key, member);
        this.results.add(new FutureResult(c));
    }

    protected void smembers(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.smembers(key);
        this.results.add(new FutureResult(c));
    }

    protected void srem(String key, String member) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.srem(key, member);
        this.results.add(new FutureResult(c));
    }

    protected void spop(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.spop(key);
        this.results.add(new FutureResult(c));
    }

    protected void scard(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.scard(key);
        this.results.add(new FutureResult(c));
    }

    protected void sismember(String key, String member) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.sismember(key, member);
        this.results.add(new FutureResult(c));
    }

    protected void srandmember(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.srandmember(key);
        this.results.add(new FutureResult(c));
    }

    protected void zadd(String key, double score, String member) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zadd(key, score, member);
        this.results.add(new FutureResult(c));
    }

    protected void zrange(String key, int start, int end) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrange(key, start, end);
        this.results.add(new FutureResult(c));
    }

    protected void zrem(String key, String member) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrem(key, member);
        this.results.add(new FutureResult(c));
    }

    protected void zincrby(String key, double score, String member) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zincrby(key, score, member);
        this.results.add(new FutureResult(c));
    }

    protected void zrank(String key, String member) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrank(key, member);
        this.results.add(new FutureResult(c));
    }

    protected void zrevrank(String key, String member) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrevrank(key, member);
        this.results.add(new FutureResult(c));
    }

    protected void zrevrange(String key, int start, int end) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrevrange(key, start, end);
        this.results.add(new FutureResult(c));
    }

    protected void zrangeWithScores(String key, int start, int end) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrangeWithScores(key, start, end);
        this.results.add(new FutureResult(c));
    }

    protected void zrevrangeWithScores(String key, int start, int end) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrevrangeWithScores(key, start, end);
        this.results.add(new FutureResult(c));
    }

    protected void zcard(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zcard(key);
        this.results.add(new FutureResult(c));
    }

    protected void zscore(String key, String member) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zscore(key, member);
        this.results.add(new FutureResult(c));
    }

    protected void sort(String key) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.sort(key);
        this.results.add(new FutureResult(c));
    }

    protected void sort(String key, SortingParams sortingParameters) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.sort(key, sortingParameters);
        this.results.add(new FutureResult(c));
    }

    protected void zcount(String key, double min, double max) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zcount(key, min, max);
        this.results.add(new FutureResult(c));
    }

    protected void zrangeByScore(String key, double min, double max) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrangeByScore(key, min, max);
        this.results.add(new FutureResult(c));
    }

    protected void zrangeByScore(String key, double min, double max, int offset, int count) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrangeByScore(key, min, max, offset, count);
        this.results.add(new FutureResult(c));
    }

    protected void zrangeByScoreWithScores(String key, double min, double max) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrangeByScoreWithScores(key, min, max);
        this.results.add(new FutureResult(c));
    }

    protected void zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zrangeByScoreWithScores(key, min, max, offset, count);
        this.results.add(new FutureResult(c));
    }

    protected void zremrangeByRank(String key, int start, int end) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zremrangeByRank(key, start, end);
        this.results.add(new FutureResult(c));
    }

    protected void zremrangeByScore(String key, double start, double end) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.zremrangeByScore(key, start, end);
        this.results.add(new FutureResult(c));
    }

    protected void linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        Client c = ((Jedis)this.jedis.getShard(key)).getClient();
        c.linsert(key, where, pivot, value);
        this.results.add(new FutureResult(c));
    }

    public List<Object> getResults() {
        ArrayList<Object> r = new ArrayList<Object>();
        for (FutureResult fr : this.results) {
            r.add(fr.get());
        }
        return r;
    }

    public abstract void execute();

    private class FutureResult {
        private Client client;

        public FutureResult(Client client) {
            this.client = client;
        }

        public Object get() {
            return this.client.getOne();
        }
    }
}

